/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy;

import net.minecraft.world.World;

public class SunCoef {
    private final World world;
    private double coef;

    public SunCoef(World world) {
        this.world = world;
        this.coef = 0.0;
    }

    public double getCoef() {
        return this.coef;
    }

    public void calculate() {
        double k = 0.0;
        float angle = this.getWorld().func_72826_c(1.0f) - 0.78469056f < 0.0f ? 0.21530944f : -0.78469056f;
        float celestialAngle = (this.getWorld().func_72826_c(1.0f) + angle) * 360.0f;
        celestialAngle %= 360.0f;
        if ((celestialAngle += 12.0f) <= 90.0f) {
            k = celestialAngle / 90.0f;
        } else if (celestialAngle > 90.0f && celestialAngle < 180.0f) {
            k = 1.0f - (celestialAngle -= 90.0f) / 90.0f;
        } else if (celestialAngle > 180.0f && celestialAngle < 270.0f) {
            k = (celestialAngle -= 180.0f) / 90.0f;
        } else if (celestialAngle > 270.0f && celestialAngle < 360.0f) {
            k = 1.0f - (celestialAngle -= 270.0f) / 90.0f;
        }
        this.coef = k;
    }

    private World getWorld() {
        return this.world;
    }
}

