/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy;

import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergySink;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.EnumFacing;

public class Path {
    final List<IEnergyConductor> conductors;
    final IEnergySink target;
    final EnumFacing targetDirection;
    long totalEnergyConducted;
    double min = Double.MAX_VALUE;
    double loss = 0.0;
    boolean hasController = false;
    boolean isLimit = false;
    double limit_amount = Double.MAX_VALUE;

    Path(IEnergySink sink, EnumFacing facing) {
        this.target = sink;
        this.conductors = new ArrayList<IEnergyConductor>();
        this.totalEnergyConducted = 0L;
        this.targetDirection = facing;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() && !(o instanceof IEnergySink)) {
            return false;
        }
        if (o instanceof IEnergySink) {
            IEnergySink energySink = (IEnergySink)o;
            return energySink == this.target;
        }
        Path path = (Path)o;
        return this.target == path.target;
    }

    public int hashCode() {
        return Objects.hash(this.target);
    }

    public List<IEnergyConductor> getConductors() {
        return this.conductors;
    }

    public void setHasController(boolean hasController) {
        this.hasController = hasController;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public void tick(int tick, double adding) {
        if (this.target.isSink()) {
            if (this.target.getTick() != (double)tick) {
                this.target.addTick(tick);
                this.target.setPastEnergy(this.target.getPerEnergy());
            }
            this.target.addPerEnergy(adding);
        }
    }
}

