/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.crafting;

import com.denfop.api.Recipes;
import com.denfop.api.crafting.PartRecipe;
import com.denfop.api.crafting.RecipeGrid;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.IngredientInput;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import org.jetbrains.annotations.Nullable;

public class BaseRecipe
implements IShapedRecipe {
    private final ItemStack output;
    private final int[][] inputIndex;
    private final int[] inputIndexCraftingTable = new int[4];
    private final IInputItemStack[][] input;
    private final int size;
    private final NonNullList<Ingredient> listIngridient;
    private final int minX;
    private final int minY;
    private final int x;
    private final int y;
    private final int index;
    private ResourceLocation name;

    public BaseRecipe(ItemStack output, RecipeGrid recipeGrid, List<PartRecipe> partRecipe) {
        int j;
        this.output = output;
        this.size = recipeGrid.getGrids().size();
        this.minX = recipeGrid.isHasTwoX() ? 2 : 3;
        this.minY = recipeGrid.isHasTwoY() ? 2 : 3;
        this.x = recipeGrid.getX2();
        this.y = recipeGrid.getY2();
        this.index = recipeGrid.getIndex();
        this.inputIndex = new int[recipeGrid.getGrids().size()][9];
        this.input = new IInputItemStack[recipeGrid.getGrids().size()][9];
        for (j = 0; j < recipeGrid.getGrids().size(); ++j) {
            for (PartRecipe recipe : partRecipe) {
                List<Integer> integerList = recipeGrid.getIndexesInGrid(j, recipe);
                for (int i : integerList) {
                    this.inputIndex[j][i] = 1;
                    this.input[j][i] = recipe.getInput();
                }
            }
        }
        this.listIngridient = NonNullList.func_191196_a();
        for (int x = 0; x < 9; ++x) {
            if (this.inputIndex[0][x] != 0) {
                this.listIngridient.add((Object)new IngredientInput(this.input[0][x]));
                continue;
            }
            this.listIngridient.add((Object)Ingredient.field_193370_a);
        }
        if (this.minX == 2 && this.minY == 2) {
            j = 0;
            for (int x = 0; x < 3; ++x) {
                if (x == this.x) continue;
                for (int y = 0; y < 3; ++y) {
                    if (this.y == y) continue;
                    this.inputIndexCraftingTable[j] = x + y * 3;
                    ++j;
                }
            }
        }
        Recipes.registerRecipe((IRecipe)this);
    }

    public int[] getInputIndex() {
        return this.inputIndex[0];
    }

    public IInputItemStack[] getInput() {
        return this.input[0];
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.listIngridient;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        return NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public int getRecipeWidth() {
        return 3;
    }

    public int getRecipeHeight() {
        return 3;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.func_77572_b(inv) != ItemStack.field_190927_a;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (inv.func_174922_i() < 3 || inv.func_174923_h() < 3) {
            if (this.minY == 2 && this.minX == 2 && inv.func_174922_i() == 2 && inv.func_174923_h() == 2) {
                for (int i = 0; i < 4; ++i) {
                    ItemStack offer = inv.func_70301_a(i);
                    if (this.inputIndex[this.index][this.inputIndexCraftingTable[i]] == 0 && !offer.func_190926_b()) {
                        return ItemStack.field_190927_a;
                    }
                    if (this.inputIndex[this.index][this.inputIndexCraftingTable[i]] != 0 && offer.func_190926_b()) {
                        return ItemStack.field_190927_a;
                    }
                    if (this.inputIndex[this.index][this.inputIndexCraftingTable[i]] == 0 && offer.func_190926_b() || this.input[this.index][this.inputIndexCraftingTable[i]].matches(offer)) continue;
                    return ItemStack.field_190927_a;
                }
                return this.output.func_77946_l();
            }
            return ItemStack.field_190927_a;
        }
        for (int j = 0; j < this.size; ++j) {
            if (j != this.size - 1) {
                boolean has = true;
                for (int i = 0; i < inv.func_174923_h() * inv.func_174922_i(); ++i) {
                    ItemStack offer = inv.func_70301_a(i);
                    if (this.inputIndex[j][i] == 0 && !offer.func_190926_b()) {
                        has = false;
                        break;
                    }
                    if (this.inputIndex[j][i] != 0 && offer.func_190926_b()) {
                        has = false;
                        break;
                    }
                    if (this.inputIndex[j][i] == 0 && offer.func_190926_b() || this.input[j][i].matches(offer)) continue;
                    has = false;
                    break;
                }
                if (!has) continue;
                return this.output.func_77946_l();
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack offer = inv.func_70301_a(i);
                if (this.inputIndex[j][i] == 0 && !offer.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (this.inputIndex[j][i] != 0 && offer.func_190926_b()) {
                    return ItemStack.field_190927_a;
                }
                if (this.inputIndex[j][i] == 0 && offer.func_190926_b() || this.input[j][i].matches(offer)) continue;
                return ItemStack.field_190927_a;
            }
        }
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return 3 == width && height == 3;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public IRecipe setRegistryName(ResourceLocation name) {
        this.name = name;
        return this;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.name;
    }

    public Class<IRecipe> getRegistryType() {
        return IRecipe.class;
    }
}

