/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.util;

import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.lib.util.IWithID;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.util.SNBTTagCompound;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class RayMatcher {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("(\\w+)(\\=|\\=\\=|\\>\\=|\\<\\=|\\>|\\<|\\!\\=)(\\w+)");
    public Type type = Type.BLOCK_ID;
    public String match = "";
    public final Map<String, String> properties = new HashMap<String, String>();
    public NBTTagCompound nbtData = null;

    public void writeData(NBTTagCompound nbt) {
        nbt.func_74778_a("match_type", this.type.getId());
        nbt.func_74778_a("match", this.match);
        if (!this.properties.isEmpty()) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                nbt1.func_74778_a(entry.getKey(), entry.getValue());
            }
            nbt.func_74782_a("properties", (NBTBase)nbt1);
        }
        if (this.nbtData != null && !this.nbtData.func_82582_d()) {
            nbt.func_74782_a("nbt", (NBTBase)this.nbtData);
        }
    }

    public void readData(NBTTagCompound nbt) {
        this.type = (Type)((Object)Type.NAME_MAP.get(nbt.func_74779_i("match_type")));
        this.match = nbt.func_74779_i("match");
        this.properties.clear();
        NBTTagCompound nbt1 = nbt.func_74775_l("properties");
        for (String s : nbt1.func_150296_c()) {
            this.properties.put(s, nbt1.func_74779_i(s));
        }
        this.nbtData = nbt.func_74775_l("nbt");
        if (this.nbtData.func_82582_d()) {
            this.nbtData = null;
        }
    }

    public void writeNetData(DataOut data) {
        Type.NAME_MAP.write(data, (Object)this.type);
        data.writeString(this.match);
        data.writeMap(this.properties, DataOut.STRING, DataOut.STRING);
        data.writeNBT(this.nbtData);
    }

    public void readNetData(DataIn data) {
        this.type = (Type)((Object)Type.NAME_MAP.read(data));
        this.match = data.readString();
        data.readMap(this.properties, DataIn.STRING, DataIn.STRING);
        this.nbtData = data.readNBT();
    }

    public boolean stringMatches(Data data) {
        if (this.match.isEmpty()) {
            return false;
        }
        switch (this.type) {
            case BLOCK_ID: {
                return this.match.equals(data.blockId);
            }
            case BLOCK_ENTITY_ID: {
                return this.match.equals(data.blockEntityId);
            }
            case BLOCK_ENTITY_CLASS: {
                return this.match.equals(data.blockEntityClass);
            }
            case ENTITY_ID: {
                return this.match.equals(data.entityId);
            }
            case ENTITY_CLASS: {
                return this.match.equals(data.entityClass);
            }
        }
        return false;
    }

    public boolean propertiesMatch(Data data) {
        if (this.type.nbt) {
            if (this.nbtData == null || this.nbtData.func_82582_d()) {
                return true;
            }
            NBTTagCompound n = data.getNBT();
            if (n == null || n.func_82582_d()) {
                return false;
            }
            for (String key : this.nbtData.func_150296_c()) {
                if (Objects.equals(this.nbtData.func_74781_a(key), n.func_74781_a(key))) continue;
                return false;
            }
            return true;
        }
        if (this.properties.isEmpty() || !this.type.block) {
            return true;
        }
        if (this.properties.size() > data.getBlockProperties().size()) {
            return false;
        }
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            String s = data.getBlockProperties().get(entry.getKey());
            if (s != null && s.equals(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    public boolean matches(Data data) {
        return data != Data.EMPTY && this.stringMatches(data) && this.propertiesMatch(data);
    }

    public String getPropertyString() {
        if (this.type.nbt) {
            return this.nbtData == null ? "" : this.nbtData.toString();
        }
        if (this.properties.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
            }
            builder.append(entry.getKey());
            builder.append('=');
            builder.append(entry.getValue());
        }
        return builder.toString();
    }

    public void setPropertyString(String s) {
        this.properties.clear();
        this.nbtData = null;
        if (this.type.nbt) {
            if (!s.isEmpty()) {
                try {
                    this.nbtData = JsonToNBT.func_180713_a((String)s);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        for (String s1 : s.split(",")) {
            String[] s2 = s1.split("=", 2);
            if (s2.length != 2) continue;
            this.properties.put(s2[0], s2[1]);
        }
    }

    public static class Data {
        public static final Data EMPTY = new Data();
        private final IBlockState state;
        private final TileEntity tileEntity;
        private final Entity entity;
        public final String blockId;
        public final String blockEntityClass;
        public final String blockEntityId;
        public final String entityClass;
        public final String entityId;
        private boolean readProperties;
        private boolean readNBT;
        private Map<String, String> blockProperties;
        private NBTTagCompound nbt;

        public static Data get(IBlockState state, @Nullable TileEntity tileEntity, @Nullable Entity entity) {
            if (state == BlockUtils.AIR_STATE && tileEntity == null && entity == null) {
                return EMPTY;
            }
            return new Data(state, tileEntity, entity);
        }

        public static Data get(World world, @Nullable RayTraceResult ray) {
            if (ray == null || ray.field_72313_a == RayTraceResult.Type.MISS) {
                return EMPTY;
            }
            if (ray.field_72313_a == RayTraceResult.Type.BLOCK) {
                return Data.get(world.func_180495_p(ray.func_178782_a()), world.func_175625_s(ray.func_178782_a()), ray.field_72308_g);
            }
            if (ray.field_72308_g != null) {
                return Data.get(BlockUtils.AIR_STATE, null, ray.field_72308_g);
            }
            return EMPTY;
        }

        public static Data get(EntityPlayer player) {
            return Data.get(player.field_70170_p, MathUtils.rayTrace((EntityPlayer)player, (boolean)true));
        }

        private Data() {
            this.state = Blocks.field_150350_a.func_176223_P();
            this.tileEntity = null;
            this.entity = null;
            this.blockId = "";
            this.blockProperties = Collections.emptyMap();
            this.blockEntityClass = "null";
            this.blockEntityId = "null";
            this.entityClass = "null";
            this.entityId = "null";
        }

        private Data(IBlockState s, @Nullable TileEntity te, @Nullable Entity e) {
            this.state = s;
            this.tileEntity = te;
            this.entity = e;
            this.blockId = String.valueOf(this.state.func_177230_c().getRegistryName());
            if (this.tileEntity == null) {
                this.blockEntityId = "null";
                this.blockEntityClass = "null";
            } else {
                this.blockEntityClass = this.tileEntity.getClass().getName();
                this.blockEntityId = String.valueOf(TileEntity.func_190559_a(this.tileEntity.getClass()));
            }
            if (this.entity == null) {
                this.entityId = "";
                this.entityClass = "";
            } else {
                this.entityClass = this.entity.getClass().getName();
                EntityEntry entityEntry = EntityRegistry.getEntry(this.entity.getClass());
                this.entityId = entityEntry == null ? "null" : String.valueOf(entityEntry.getRegistryName());
            }
        }

        public Map<String, String> getBlockProperties() {
            if (this.readProperties) {
                return this.blockProperties;
            }
            this.blockProperties = new HashMap<String, String>();
            for (Map.Entry entry : this.state.func_177228_b().entrySet()) {
                this.blockProperties.put(((IProperty)entry.getKey()).func_177701_a(), ((IProperty)entry.getKey()).func_177702_a((Comparable)entry.getValue()));
            }
            this.readProperties = true;
            return this.blockProperties;
        }

        @Nullable
        public NBTTagCompound getNBT() {
            if (this.readNBT) {
                return this.nbt;
            }
            this.nbt = null;
            if (this.tileEntity != null) {
                this.nbt = this.tileEntity.serializeNBT();
            } else if (this.entity != null) {
                this.nbt = this.entity.serializeNBT();
            }
            return this.nbt;
        }

        public String toString() {
            SNBTTagCompound nbt = new SNBTTagCompound();
            nbt.func_74778_a("state", this.state.toString());
            nbt.func_74757_a("tileEntity", this.tileEntity != null);
            nbt.func_74757_a("entity", this.entity != null);
            nbt.func_74778_a("blockId", this.blockId);
            nbt.func_74778_a("blockEntityClass", this.blockEntityClass);
            nbt.func_74778_a("blockEntityId", this.blockEntityId);
            nbt.func_74778_a("entityClass", this.entityClass);
            nbt.func_74778_a("entityId", this.entityId);
            nbt.func_74778_a("blockProperties", this.getBlockProperties().toString());
            if (this.getNBT() != null) {
                nbt.func_74782_a("nbt", (NBTBase)this.getNBT());
            } else {
                nbt.func_74778_a("nbt", "null");
            }
            return NBTUtils.getColoredNBTString((NBTBase)nbt);
        }
    }

    @FunctionalInterface
    public static interface NBTSupplier {
        @Nullable
        public NBTTagCompound get();
    }

    public static enum Type implements IWithID
    {
        BLOCK_ID("block_id", true, false),
        BLOCK_ENTITY_ID("block_entity_id", true, true),
        BLOCK_ENTITY_CLASS("block_entity_class", true, true),
        ENTITY_ID("entity_id", false, true),
        ENTITY_CLASS("entity_class", false, true);

        public static final NameMap<Type> NAME_MAP;
        private final String name;
        public final boolean block;
        public final boolean nbt;

        private Type(String n2, boolean b, boolean nb) {
            this.name = n2;
            this.block = b;
            this.nbt = nb;
        }

        public String getId() {
            return this.name;
        }

        static {
            NAME_MAP = NameMap.createWithBaseTranslationKey((Object)((Object)BLOCK_ID), (String)"ftbquests.raymatcher", (Object[])Type.values());
        }
    }
}

