/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.EnumTristate;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.integration.jei.FTBQuestsJEIHelper;
import com.feed_the_beast.ftbquests.net.MessageClaimReward;
import com.feed_the_beast.ftbquests.quest.ChangeProgress;
import com.feed_the_beast.ftbquests.quest.Chapter;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.reward.RewardAutoClaim;
import com.feed_the_beast.ftbquests.quest.reward.RewardType;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Reward
extends QuestObjectBase {
    public Quest quest;
    public EnumTristate team;
    public RewardAutoClaim autoclaim;

    public Reward(Quest q) {
        this.quest = q;
        this.team = EnumTristate.DEFAULT;
        this.autoclaim = RewardAutoClaim.DEFAULT;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.REWARD;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    @Nullable
    public final Chapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final int getParentID() {
        return this.quest.id;
    }

    public abstract RewardType getType();

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        this.team.write(nbt, "team_reward");
        if (this.autoclaim != RewardAutoClaim.DEFAULT) {
            nbt.func_74778_a("auto", this.autoclaim.getId());
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.team = EnumTristate.read((NBTTagCompound)nbt, (String)"team_reward");
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.get(nbt.func_74779_i("auto")));
        if (nbt.func_74764_b("autoclaim") || nbt.func_74764_b("invisible")) {
            if (nbt.func_74767_n("invisible")) {
                this.autoclaim = RewardAutoClaim.INVISIBLE;
            } else if (nbt.func_74764_b("autoclaim")) {
                this.autoclaim = nbt.func_74767_n("autoclaim") ? RewardAutoClaim.ENABLED : RewardAutoClaim.DISABLED;
            }
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        EnumTristate.NAME_MAP.write(data, (Object)this.team);
        RewardAutoClaim.NAME_MAP.write(data, (Object)this.autoclaim);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.team = (EnumTristate)EnumTristate.NAME_MAP.read(data);
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.read(data));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("team", () -> this.team, v -> {
            this.team = v;
        }, EnumTristate.NAME_MAP).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.team_reward", new Object[0])).setCanEdit(!this.quest.canRepeat);
        config.addEnum("autoclaim", () -> this.autoclaim, v -> {
            this.autoclaim = v;
        }, RewardAutoClaim.NAME_MAP).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.autoclaim", new Object[0]));
    }

    public abstract void claim(EntityPlayerMP var1, boolean var2);

    public boolean automatedClaimPre(TileEntity tileEntity, List<ItemStack> items, Random random, UUID playerId, @Nullable EntityPlayerMP player) {
        return player != null;
    }

    public void automatedClaimPost(TileEntity tileEntity, UUID playerId, @Nullable EntityPlayerMP player) {
        if (player != null) {
            this.claim(player, false);
        }
    }

    @Override
    public final void deleteSelf() {
        this.quest.rewards.remove(this);
        Set<Reward> c = Collections.singleton(this);
        for (QuestData questData : this.getQuestFile().getAllData()) {
            questData.unclaimRewards(c);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        Set<Reward> c = Collections.singleton(this);
        for (QuestData questData : this.getQuestFile().getAllData()) {
            questData.unclaimRewards(c);
        }
        super.deleteChildren();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null && gui.getViewedQuest() != null) {
            gui.viewQuestPanel.refreshWidgets();
        }
        if (gui != null) {
            gui.questPanel.refreshWidgets();
        }
    }

    @Override
    public void onCreated() {
        this.quest.rewards.add(this);
    }

    public final boolean isTeamReward() {
        return this.quest.canRepeat || this.team.get(this.quest.chapter.file.defaultRewardTeam);
    }

    public final RewardAutoClaim getAutoClaimType() {
        if (this.quest.chapter.alwaysInvisible && (this.autoclaim == RewardAutoClaim.DEFAULT || this.autoclaim == RewardAutoClaim.DISABLED)) {
            return RewardAutoClaim.ENABLED;
        }
        if (this.autoclaim == RewardAutoClaim.DEFAULT) {
            return this.quest.chapter.file.defaultRewardAutoClaim;
        }
        return this.autoclaim;
    }

    @Override
    public final void changeProgress(QuestData data, ChangeProgress type) {
        if (type == ChangeProgress.RESET || type == ChangeProgress.RESET_DEPS) {
            data.unclaimRewards(Collections.singleton(this));
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    public String getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        RewardType type = this.getType();
        return group.getGroup(this.getObjectType().getId()).getGroup(type.getRegistryName().func_110624_b()).getGroup(type.getRegistryName().func_110623_a());
    }

    public void addMouseOverText(List<String> list) {
    }

    public boolean addTitleInMouseOverText() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(boolean canClick) {
        if (canClick) {
            GuiHelper.playClickSound();
            new MessageClaimReward(this.id, true).sendToServer();
        }
    }

    public boolean getExcludeFromClaimAll() {
        return this.getType().getExcludeFromListRewards();
    }

    @Nullable
    public Object getIngredient() {
        return this.getIcon().getIngredient();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    public String getButtonText() {
        return "";
    }
}

