/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.MessageDeleteObjectResponse;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.util.ServerQuestData;
import io.sommers.packmode.api.PackModeAPI;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;

public class ServerQuestFile
extends QuestFile {
    public static ServerQuestFile INSTANCE;
    public final Universe universe;
    public boolean shouldSave = false;
    private boolean isLoading = false;
    private File folder;

    public ServerQuestFile(Universe u) {
        this.universe = u;
    }

    private String getFolderName() {
        if (this.universe.world.func_82736_K().func_82765_e("questfile")) {
            return this.universe.world.func_82736_K().func_82767_a("questfile");
        }
        if (Loader.isModLoaded((String)"packmode")) {
            return ServerQuestFile.getPackmodeFolderName();
        }
        return "normal";
    }

    private static String getPackmodeFolderName() {
        return PackModeAPI.getInstance().getCurrentPackMode();
    }

    public void load() {
        this.folderName = this.getFolderName();
        this.folder = new File(Loader.instance().getConfigDir(), "ftbquests/" + this.folderName);
        if (this.folder.exists()) {
            FTBQuests.LOGGER.info("Loading quests from " + this.folder.getAbsolutePath());
            this.isLoading = true;
            this.readDataFull(this.folder);
            this.isLoading = false;
        }
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    public File getFolder() {
        return this.folder;
    }

    @Override
    @Nullable
    public ServerQuestData getData(short team) {
        if (team == 0) {
            return null;
        }
        ForgeTeam t = this.universe.getTeam(team);
        return t.isValid() ? ServerQuestData.get(t) : null;
    }

    @Override
    @Nullable
    public ServerQuestData getData(String team) {
        if (team.isEmpty()) {
            return null;
        }
        ForgeTeam t = this.universe.getTeam(team);
        return t.isValid() ? ServerQuestData.get(t) : null;
    }

    @Override
    @Nullable
    public ServerQuestData getData(UUID player) {
        return this.getData(FTBLibAPI.getTeamID((UUID)player));
    }

    public Collection<ServerQuestData> getAllData() {
        Collection teams = this.universe.getTeams();
        ArrayList<ServerQuestData> list = new ArrayList<ServerQuestData>(teams.size());
        for (ForgeTeam team : teams) {
            if (!team.isValid()) continue;
            list.add(ServerQuestData.get(team));
        }
        return list;
    }

    @Override
    public void deleteObject(int id) {
        QuestObjectBase object = this.getBase(id);
        if (object != null) {
            File file = object.getFile();
            object.deleteChildren();
            object.deleteSelf();
            this.refreshIDMap();
            this.save();
            if (file != null) {
                FileUtils.deleteSafe((File)file);
            }
        }
        new MessageDeleteObjectResponse(id).sendToAll();
    }

    public void save() {
        this.shouldSave = true;
        this.universe.markDirty();
    }

    public void saveNow() {
        this.writeDataFull(this.getFolder());
    }

    public void unload() {
        if (this.shouldSave) {
            this.saveNow();
            this.shouldSave = false;
        }
        this.deleteChildren();
        this.deleteSelf();
    }
}

