/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.client.PixelBuffer;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.ImageIcon;
import com.feed_the_beast.ftblib.lib.util.IWithID;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class QuestShape
extends Icon
implements IWithID {
    public static final Map<String, QuestShape> MAP = new LinkedHashMap<String, QuestShape>();
    private static QuestShape defaultShape;
    public static NameMap<String> idMap;
    public static NameMap<String> idMapWithDefault;
    public final String id;
    public final ImageIcon background;
    public final ImageIcon outline;
    public final ImageIcon shape;
    private PixelBuffer shapePixels;

    public static void reload(List<String> list) {
        MAP.clear();
        for (String s : list) {
            MAP.put(s, new QuestShape(s));
        }
        defaultShape = MAP.values().iterator().next();
        idMap = NameMap.createWithBaseTranslationKey((Object)list.get(0), (String)"ftbquests.quest.shape", (Object[])list.toArray(new String[0]));
        list.add(0, "default");
        idMapWithDefault = NameMap.createWithBaseTranslationKey((Object)list.get(0), (String)"ftbquests.quest.shape", (Object[])list.toArray(new String[0]));
    }

    public static QuestShape get(String id) {
        return MAP.getOrDefault(id, defaultShape);
    }

    public QuestShape(String i) {
        this.id = i;
        this.background = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/background.png"));
        this.outline = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/outline.png"));
        this.shape = new ImageIcon(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/shape.png"));
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return "quest_shape:" + this.id;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(int x, int y, int w, int h) {
        this.background.draw(x, y, w, h);
        this.outline.draw(x, y, w, h);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public PixelBuffer getShapePixels() {
        if (this.shapePixels == null) {
            try {
                IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("ftbquests", "textures/shapes/" + this.id + "/shape.png"));
                try (InputStream stream = resource.func_110527_b();){
                    this.shapePixels = PixelBuffer.from((InputStream)stream);
                }
            }
            catch (Exception ex) {
                this.shapePixels = new PixelBuffer(1, 1);
                this.shapePixels.setRGB(0, 0, -1);
            }
        }
        return this.shapePixels;
    }
}

