/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.DivineRPG;
import divinerpg.api.DivineAPI;
import divinerpg.api.armor.ArmorEquippedEvent;
import divinerpg.api.armor.cap.IArmorPowers;
import divinerpg.api.armor.registry.IArmorDescription;
import divinerpg.networking.message.ArmorStatusChangedMessage;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber
public class ArmorWearingEvents {
    public static void recheckAllWearing(Entity player, boolean forced) {
        IArmorPowers powers = DivineAPI.getArmorPowers(player);
        if (powers == null) {
            return;
        }
        ArmorEquippedEvent armorEquippedEvent = new ArmorEquippedEvent(player);
        MinecraftForge.EVENT_BUS.post((Event)armorEquippedEvent);
        Set<ResourceLocation> confirmed = armorEquippedEvent.getConfirmed();
        Set<ResourceLocation> current = powers.wearing();
        List<ResourceLocation> newWearing = confirmed.stream().filter(x -> !current.contains(x)).collect(Collectors.toList());
        List<ResourceLocation> takenOff = current.stream().filter(x -> !confirmed.contains(x)).collect(Collectors.toList());
        takenOff.forEach(powers::takeOff);
        newWearing.forEach(powers::putOn);
        if (forced && player instanceof EntityPlayerMP) {
            current.removeAll(takenOff);
            current.removeAll(newWearing);
            current.stream().map(x -> new ArmorStatusChangedMessage((ResourceLocation)x, true)).forEach(x -> DivineRPG.network.sendTo((IMessage)x, (EntityPlayerMP)player));
        }
    }

    @SubscribeEvent
    public static void notifyChanges(LivingEquipmentChangeEvent event) {
        ArmorWearingEvents.recheckAllWearing(event.getEntity(), false);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void detectIsOn(ArmorEquippedEvent event) {
        IForgeRegistry<IArmorDescription> registry = DivineAPI.getArmorDescriptionRegistry();
        if (registry == null) {
            return;
        }
        ((Stream)registry.getEntries().parallelStream().filter(x -> x.getValue() != null).filter(x -> {
            IArmorDescription description = (IArmorDescription)x.getValue();
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                Set<Item> setItems = description.getPossibleItems(slot);
                Set<Item> currentItems = event.getItemsInSlot(slot);
                if (setItems.isEmpty()) continue;
                if (!setItems.stream().noneMatch(currentItems::contains)) continue;
                return false;
            }
            return true;
        }).sequential()).forEach(x -> event.confirm((ResourceLocation)x.getKey()));
    }
}

