/*
 * Decompiled with CFR 0.152.
 */
package primetoxinz.coralreef;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import primetoxinz.coralreef.CoralReef;

public class BlockCoral
extends Block
implements IPlantable {
    public static final int NTYPES = 6;
    public static final EnumPlantType CORAL = EnumPlantType.getPlantType((String)"Coral");
    public static final PropertyInteger TYPES = PropertyInteger.func_177719_a((String)"types", (int)0, (int)5);
    protected static final AxisAlignedBB CORAL_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockCoral() {
        super(Material.field_151586_h);
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78026_f);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)TYPES, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(15)));
    }

    public boolean highVariant(int variant) {
        return variant > 3;
    }

    public boolean placeAt(World world, BlockPos bottom) {
        boolean placed = false;
        if (this.func_176196_c(world, bottom)) {
            int variant = world.field_73012_v.nextInt(6);
            if (this.highVariant(variant)) {
                BlockPos bp;
                int height = world.field_73012_v.nextInt(4);
                for (int i = 0; i < height && world.func_180495_p((bp = bottom.func_177981_b(i)).func_177984_a()).func_185904_a() == Material.field_151586_h; ++i) {
                    placed = world.func_175656_a(bp, this.func_176223_P().func_177226_a((IProperty)TYPES, (Comparable)Integer.valueOf(variant)));
                }
            } else {
                placed = world.func_175656_a(bottom, this.func_176223_P().func_177226_a((IProperty)TYPES, (Comparable)Integer.valueOf(variant)));
            }
        }
        return placed;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (worldIn.func_180495_p(pos.func_177984_a()).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        if (block.canSustainPlant(state, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this)) {
            return true;
        }
        if (block == this) {
            int variant = (Integer)state.func_177229_b((IProperty)TYPES);
            return this.highVariant(variant);
        }
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 6; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, ((Integer)state.func_177229_b((IProperty)TYPES)).intValue());
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockLiquid.field_176367_b, TYPES});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)TYPES, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPES);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return Block.field_185506_k;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CORAL_AABB;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.checkAndDropBlock(worldIn, pos, state);
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)TYPES);
    }

    protected boolean checkAndDropBlock(World worldIn, BlockPos pos, IBlockState state) {
        if (this.canBlockStay(worldIn, pos, state)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        if (CoralReef.ConfigHandler.bubbles && world.func_180495_p(pos.func_177984_a()).func_185904_a() == Material.field_151586_h) {
            double offset = 0.0625;
            for (int i = 0; i < 6; ++i) {
                double x1 = (double)pos.func_177958_n() + rand.nextDouble();
                double y1 = (double)pos.func_177956_o() + rand.nextDouble();
                double z1 = (double)pos.func_177952_p() + rand.nextDouble();
                if (i == 0 && !world.func_180495_p(pos.func_177984_a()).func_185898_k()) {
                    y1 = (double)(pos.func_177956_o() + 1) + offset;
                }
                if (i == 1 && !world.func_180495_p(pos.func_177977_b()).func_185898_k()) {
                    y1 = (double)pos.func_177956_o() - offset;
                }
                if (i == 2 && !world.func_180495_p(pos.func_177972_a(EnumFacing.SOUTH)).func_185898_k()) {
                    z1 = (double)(pos.func_177952_p() + 1) + offset;
                }
                if (i == 3 && !world.func_180495_p(pos.func_177972_a(EnumFacing.NORTH)).func_185898_k()) {
                    z1 = (double)pos.func_177952_p() - offset;
                }
                if (i == 4 && !world.func_180495_p(pos.func_177972_a(EnumFacing.EAST)).func_185898_k()) {
                    x1 = (double)(pos.func_177958_n() + 1) + offset;
                }
                if (i == 5 && !world.func_180495_p(pos.func_177972_a(EnumFacing.WEST)).func_185898_k()) {
                    x1 = (double)pos.func_177958_n() - offset;
                }
                if (!(x1 < (double)pos.func_177958_n() || x1 > (double)(pos.func_177956_o() + 1) || y1 < 0.0 || y1 > (double)(pos.func_177956_o() + 1) || z1 < (double)pos.func_177952_p()) && !(z1 > (double)(pos.func_177952_p() + 1))) continue;
                world.func_175688_a(EnumParticleTypes.WATER_BUBBLE, x1, y1, z1, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean canBlockStay(World world, BlockPos pos, IBlockState state) {
        return this.func_176196_c(world, pos);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CoralReef.ConfigHandler.coralLightLevel;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return CORAL;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }
}

