/*
 * Decompiled with CFR 0.152.
 */
package dev.ricobrase.chatcalculator.termsolver;

import dev.ricobrase.chatcalculator.termsolver.Operators;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.StringJoiner;

public class TermSolver {
    static Map<String, Operators> operators = new HashMap<String, Operators>(){
        {
            this.put("+", Operators.PLUS);
            this.put("-", Operators.MINUS);
            this.put("*", Operators.MULTIPLY);
            this.put("/", Operators.DIVIDE);
            this.put("^", Operators.POW);
        }
    };

    public static Optional<String> transformInfixToPostfix(String input) {
        char[] infix = input.replaceAll(" ", "").toCharArray();
        Stack<String> opStack = new Stack<String>();
        StringJoiner postfix = new StringJoiner(" ");
        StringBuilder operand = new StringBuilder();
        block2: for (int i = 0; i < infix.length; ++i) {
            if (!operators.containsKey(String.valueOf(infix[i])) && infix[i] != '(' && infix[i] != ')') {
                operand.append(infix[i]);
                if (i >= infix.length - 1) continue;
                continue;
            }
            if (operand.length() > 0) {
                try {
                    postfix.add(operand.toString());
                    operand = new StringBuilder();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (infix[i] == '(') {
                opStack.push("(");
                continue;
            }
            if (infix[i] == ')') {
                if (opStack.size() <= 0) continue;
                String op = (String)opStack.pop();
                while (!op.equals("(")) {
                    postfix.add(op);
                    op = (String)opStack.pop();
                    if (opStack.size() != 0) continue;
                    continue block2;
                }
                continue;
            }
            if (!operators.containsKey(String.valueOf(infix[i]))) continue;
            if (opStack.size() == 0 || ((String)opStack.get(opStack.size() - 1)).equals("(")) {
                opStack.push(String.valueOf(infix[i]));
                continue;
            }
            if (opStack.size() > 0 && operators.get(String.valueOf(infix[i])).getPriority() > operators.get(opStack.get(opStack.size() - 1)).getPriority() || operators.get(String.valueOf(infix[i])).getPriority() == operators.get(opStack.get(opStack.size() - 1)).getPriority() && operators.get(String.valueOf(infix[i])).isRightAssociative()) {
                opStack.push(String.valueOf(infix[i]));
                continue;
            }
            while (operators.get(String.valueOf(infix[i])).getPriority() < operators.get(opStack.get(opStack.size() - 1)).getPriority() || operators.get(String.valueOf(infix[i])).getPriority() == operators.get(opStack.get(opStack.size() - 1)).getPriority() && !operators.get(String.valueOf(infix[i])).isRightAssociative()) {
                postfix.add((CharSequence)opStack.pop());
                if (opStack.size() != 0) continue;
            }
            opStack.push(String.valueOf(infix[i]));
        }
        if (operand.length() > 0) {
            postfix.add(operand);
        }
        while (opStack.size() > 0) {
            postfix.add((CharSequence)opStack.pop());
        }
        return Optional.of(postfix.toString());
    }

    public static double solvePostfix(String input) throws NumberFormatException {
        String[] in = input.split(" ");
        Stack<Double> stack = new Stack<Double>();
        for (String o : in) {
            try {
                double operand = Double.parseDouble(o);
                stack.push(operand);
            }
            catch (NumberFormatException ex) {
                if (operators.containsKey(o)) {
                    if (stack.size() < 2) {
                        throw new NumberFormatException("Invalid operator, expected number");
                    }
                    double right = (Double)stack.pop();
                    double left = (Double)stack.pop();
                    double result = operators.get(o).compute(left, right);
                    stack.push(result);
                    continue;
                }
                throw ex;
            }
        }
        return (Double)stack.pop();
    }
}

