/*
 * Decompiled with CFR 0.152.
 */
package dev.ricobrase.chatcalculator.termsolver;

import java.util.function.DoubleBinaryOperator;

public enum Operators {
    PLUS(1, false, (l, r) -> l + r),
    MINUS(1, false, (l, r) -> l - r),
    MULTIPLY(2, false, (l, r) -> l * r),
    DIVIDE(2, false, (l, r) -> l / r),
    POW(3, true, Math::pow);

    private final int priority;
    private final boolean rightAssociative;
    private final DoubleBinaryOperator binaryOperator;

    private Operators(int priority, boolean rightAssociative, DoubleBinaryOperator binaryOperator) {
        this.priority = priority;
        this.rightAssociative = rightAssociative;
        this.binaryOperator = binaryOperator;
    }

    public double compute(double left, double right) {
        return this.binaryOperator.applyAsDouble(left, right);
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isRightAssociative() {
        return this.rightAssociative;
    }
}

