/*
 * Decompiled with CFR 0.152.
 */
package dev.ricobrase.chatcalculator.events;

import dev.ricobrase.chatcalculator.termsolver.TermSolver;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientChatEventListener {
    @SubscribeEvent
    public static void onClientChatEvent(ClientChatEvent event) {
        String chatMessage = event.getMessage();
        if (chatMessage.matches("={2}[^=]*")) {
            event.setMessage(chatMessage.substring(1));
            return;
        }
        if (chatMessage.matches("=[^=]*")) {
            block7: {
                Optional<String> postfix = TermSolver.transformInfixToPostfix(chatMessage.substring(1));
                if (postfix.isPresent()) {
                    try {
                        double result = TermSolver.solvePostfix(postfix.get());
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(chatMessage.substring(1)));
                        if (result == Math.floor(result) && !Double.isInfinite(result) && result <= 2.147483647E9 && result >= -2.147483648E9) {
                            result = Math.floor(result);
                            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(String.format("= %d", (int)result)));
                            break block7;
                        }
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(String.format("= %f", result)));
                    }
                    catch (NumberFormatException ex) {
                        ClientChatEventListener.printInvalidCharactersMessage();
                    }
                } else {
                    ClientChatEventListener.printInvalidCharactersMessage();
                }
            }
            event.setCanceled(true);
        }
    }

    private static void printInvalidCharactersMessage() {
        Style redColor = new Style().func_150238_a(TextFormatting.RED);
        Minecraft.func_71410_x().field_71439_g.func_145747_a(new TextComponentTranslation("chat.chatcalculator.invalidcharacters", new Object[0]).func_150255_a(redColor));
    }
}

