/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.client;

import java.util.Map;
import java.util.TreeMap;
import net.darkhax.bookshelf.BookshelfConfig;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.ProgressManager;

public class RomanNumerals {
    private static final TreeMap<Integer, String> map = new TreeMap();

    public static final String toRoman(int number) {
        int l = map.floorKey(number);
        if (number == l) {
            return map.get(number);
        }
        return map.get(l) + RomanNumerals.toRoman(number - l);
    }

    public static void insertRomanNumerals() {
        RomanNumerals.mapLevels("Enchantment", "enchantment.level.", BookshelfConfig.translateEnchantmentCount);
    }

    private static void mapLevels(String description, String base, int maxLevel) {
        if (maxLevel > 0) {
            Map translations = net.minecraft.client.resources.I18n.field_135054_a.field_135032_a;
            Map deprecated = I18n.field_74839_a.field_74816_c;
            Map fallback = I18n.field_150828_b.field_74816_c;
            ProgressManager.ProgressBar bar = ProgressManager.push((String)("Translating " + description + " Levels"), (int)(maxLevel - 1));
            for (int lv = 1; lv < maxLevel; ++lv) {
                String roman = RomanNumerals.toRoman(lv);
                String key = base + lv;
                bar.step(lv + " = " + roman);
                translations.put(key, roman);
                deprecated.put(key, roman);
                fallback.put(key, roman);
            }
            ProgressManager.pop((ProgressManager.ProgressBar)bar);
        }
    }

    static {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    }
}

