/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.chest.infinity;

import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.ModContainer;
import wanion.avaritiaddons.block.chest.GuiAvaritiaddonsChest;
import wanion.avaritiaddons.block.chest.infinity.InfinityMatching;
import wanion.avaritiaddons.block.chest.infinity.InfinitySlot;
import wanion.avaritiaddons.block.chest.infinity.TileEntityInfinityChest;
import wanion.lib.client.gui.ITooltipSupplier;
import wanion.lib.client.gui.ItemElement;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.common.Util;
import wanion.lib.common.WContainer;

public final class GuiInfinityChest
extends GuiAvaritiaddonsChest<TileEntityInfinityChest> {
    private final NumberFormat numberFormat;

    public GuiInfinityChest(@Nonnull WContainer<TileEntityInfinityChest> wContainer) {
        super(wContainer);
        String lang = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        this.numberFormat = NumberFormat.getInstance(new Locale(lang.substring(0, 1), lang.substring(3, 4)));
    }

    protected void func_146285_a(@Nonnull ItemStack itemStack, int x, int y) {
        Slot slot = this.getSlotUnderMouse();
        if (slot instanceof InfinitySlot && slot.func_75216_d()) {
            InfinitySlot infinitySlot = (InfinitySlot)slot;
            ITooltipSupplier infinityTooltipSupplier = (interaction, stackSupplier) -> {
                ItemStack stack = (ItemStack)stackSupplier.get();
                List tooltip = ItemElement.DEFAULT_ITEMSTACK_TOOLTIP_SUPPLIER.getTooltip(interaction, stackSupplier);
                int line = this.getLine(tooltip, stack);
                tooltip.add(line, "");
                tooltip.add(++line, TextFormatting.GOLD + I18n.func_135052_a((String)"wanionlib.amount", (Object[])new Object[0]) + " " + TextFormatting.GRAY + this.numberFormat.format(infinitySlot.getInfinityMatching().getCount()));
                return tooltip;
            };
            WInteraction interaction2 = this.getLatestInteraction();
            this.func_146283_a(infinityTooltipSupplier.getTooltip(interaction2, infinitySlot::func_75211_c), interaction2.getMouseX(), interaction2.getMouseY());
        } else {
            super.func_146285_a(itemStack, x, y);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179097_i();
        for (int i = 0; i < 243; ++i) {
            InfinitySlot infinitySlot;
            InfinityMatching infinityMatching;
            Slot slot = this.field_147002_h.func_75139_a(i);
            if (!(slot instanceof InfinitySlot) || (infinityMatching = (infinitySlot = (InfinitySlot)slot).getInfinityMatching()).getCount() <= 1) continue;
            String simplifiedCount = infinityMatching.getSimplifiedCount();
            int countWidth = fontRenderer.func_78256_a(simplifiedCount);
            this.func_73731_b(fontRenderer, simplifiedCount, infinitySlot.field_75223_e + 17 - countWidth, infinitySlot.field_75221_f + 9, 0xFFFFFF);
        }
        GlStateManager.func_179126_j();
        super.func_146979_b(mouseX, mouseY);
    }

    private int getLine(@Nonnull List<String> tooltip, @Nonnull ItemStack stack) {
        int i;
        ModContainer modContainer = Util.getModContainerFromStack((ItemStack)stack);
        String modName = modContainer != null ? modContainer.getName() : null;
        if (modName == null) {
            return i;
        }
        for (i = tooltip.size() - 1; i > 0; --i) {
            if (!tooltip.get(i).contains(modName)) continue;
            return i;
        }
        return tooltip.size() - 1;
    }
}

