/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.chest;

import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import morph.avaritia.entity.EntityImmortalItem;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wanion.avaritiaddons.Avaritiaddons;
import wanion.avaritiaddons.Reference;
import wanion.avaritiaddons.block.chest.TileEntityAvaritiaddonsChest;
import wanion.avaritiaddons.block.chest.compressed.TileEntityCompressedChest;
import wanion.avaritiaddons.block.chest.infinity.TileEntityInfinityChest;
import wanion.lib.common.WrenchHelper;

public final class BlockAvaritiaddonsChest
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyInteger CHEST_TYPE = PropertyInteger.func_177719_a((String)"type", (int)0, (int)1);
    private static final AxisAlignedBB NOT_CONNECTED_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.875, 0.9375);
    public static final BlockAvaritiaddonsChest INSTANCE = new BlockAvaritiaddonsChest();

    private BlockAvaritiaddonsChest() {
        super(Material.field_151573_f);
        this.func_149647_a(Avaritiaddons.creativeTabs);
        this.setRegistryName(new ResourceLocation("avaritiaddons", "avaritiaddons_chest"));
        this.func_149663_c("avaritiaddons_chest");
        this.func_149713_g(0);
        this.func_149752_b(2000.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)CHEST_TYPE, (Comparable)Integer.valueOf(0)));
    }

    public void func_149666_a(@Nonnull CreativeTabs itemIn, @Nonnull NonNullList<ItemStack> items) {
        items.add((Object)new ItemStack((Block)this, 1, 0));
        items.add((Object)new ItemStack((Block)this, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(@Nonnull IBlockState state) {
        return true;
    }

    @Nonnull
    public Material func_149688_o(@Nonnull IBlockState state) {
        return this.func_176201_c(state) >> 2 == 0 ? Material.field_151575_d : Material.field_151573_f;
    }

    @Nonnull
    public SoundType getSoundType(@Nonnull IBlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nullable Entity entity) {
        return this.func_176201_c(state) >> 2 == 0 ? SoundType.field_185848_a : SoundType.field_185852_e;
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return NOT_CONNECTED_AABB;
    }

    public TileEntity func_149915_a(@Nonnull World world, int metadata) {
        return metadata >> 2 == 0 ? new TileEntityCompressedChest() : new TileEntityInfinityChest();
    }

    @Nonnull
    public EnumBlockRenderType func_149645_b(@Nonnull IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess worldIn, @Nonnull IBlockState state, @Nonnull BlockPos pos, @Nonnull EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return false;
    }

    @Nonnull
    public IBlockState func_180642_a(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)CHEST_TYPE, (Comparable)Integer.valueOf(meta >> 2));
    }

    public void func_180633_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityLivingBase placer, @Nonnull ItemStack itemStack) {
        NBTTagCompound stackNBT;
        if (world == null) {
            return;
        }
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3)).func_176734_d()), 3);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityAvaritiaddonsChest && (stackNBT = itemStack.func_77978_p()) != null) {
            ((TileEntityAvaritiaddonsChest)tileEntity).readCustomNBT(itemStack.func_77978_p());
        }
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)CHEST_TYPE, (Comparable)Integer.valueOf(meta >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
        return i |= (Integer)state.func_177229_b((IProperty)CHEST_TYPE) << 2;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, CHEST_TYPE});
    }

    public int getLightValue(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return this.func_176201_c(state) >> 2 == 1 ? 15 : 0;
    }

    public float func_176195_g(@Nonnull IBlockState blockState, @Nonnull World worldIn, @Nonnull BlockPos pos) {
        return this.func_176201_c(blockState) >> 2 == 0 ? 5.0f : 50.0f;
    }

    public int getHarvestLevel(@Nonnull IBlockState state) {
        return this.func_176201_c(state) >> 2 == 0 ? 2 : 3;
    }

    public boolean isToolEffective(@Nonnull String type, @Nonnull IBlockState state) {
        int meta = this.func_176201_c(state) >> 2;
        return meta == 0 && type.equals("axe") || meta == 1 && type.equals("pickaxe");
    }

    @Nonnull
    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nonnull
    public Item func_180660_a(@Nonnull IBlockState blockState, @Nonnull Random random, int fortune) {
        return Items.field_190931_a;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState state, @Nonnull EntityPlayer entityPlayer, @Nonnull EnumHand hand, @Nonnull EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!(world.field_72995_K || entityPlayer.func_70093_af() || WrenchHelper.INSTANCE.isWrench(entityPlayer.func_184586_b(hand)))) {
            TileEntity tileEntity = world.func_175625_s(blockPos);
            if (!(tileEntity instanceof TileEntityAvaritiaddonsChest)) return false;
            FMLNetworkHandler.openGui((EntityPlayer)entityPlayer, (Object)Avaritiaddons.instance, (int)(tileEntity instanceof TileEntityCompressedChest ? 1 : 2), (World)world, (int)blockPos.func_177958_n(), (int)blockPos.func_177956_o(), (int)blockPos.func_177952_p());
            return true;
        } else {
            if (world.field_72995_K || !entityPlayer.func_70093_af() || !WrenchHelper.INSTANCE.isWrench(entityPlayer.func_184586_b(hand)) || !(world.func_175625_s(blockPos) instanceof TileEntityAvaritiaddonsChest)) return true;
            world.func_175698_g(blockPos);
        }
        return true;
    }

    public int func_180651_a(@Nonnull IBlockState state) {
        return this.func_176201_c(state) >> 2;
    }

    public void func_180663_b(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState blockState) {
        if (world == null) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityAvaritiaddonsChest) {
            TileEntityAvaritiaddonsChest tileEntityAvaritiaddonsChest = (TileEntityAvaritiaddonsChest)tileEntity;
            ItemStack droppedStack = new ItemStack((Block)this, 1, this.func_176201_c(blockState) >> 2);
            NBTTagCompound nbtTagCompound = tileEntityAvaritiaddonsChest.writeCustomNBT(new NBTTagCompound());
            if (tileEntityAvaritiaddonsChest instanceof TileEntityInfinityChest) {
                this.cleanInfinityNBT(nbtTagCompound);
            }
            if (tileEntityAvaritiaddonsChest instanceof TileEntityCompressedChest && nbtTagCompound.func_150295_c("Contents", 10).func_74745_c() > 0) {
                droppedStack.func_77982_d(nbtTagCompound);
            } else if (tileEntityAvaritiaddonsChest instanceof TileEntityInfinityChest && nbtTagCompound.func_150295_c("matching", 10).func_74745_c() > 0) {
                droppedStack.func_77982_d(nbtTagCompound);
            }
            world.func_72838_d((Entity)new EntityImmortalItem(world, (double)((float)blockPos.func_177958_n() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), (double)((float)blockPos.func_177956_o() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), (double)((float)blockPos.func_177952_p() + Reference.RANDOM.nextFloat() * 0.8f + 0.1f), droppedStack));
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    private void cleanInfinityNBT(@Nonnull NBTTagCompound infinityChestNBT) {
        NBTTagList infinityList = infinityChestNBT.func_150295_c("matching", 10);
        Iterator infinityIterator = infinityList.iterator();
        while (infinityIterator.hasNext()) {
            NBTBase infinityNBT = (NBTBase)infinityIterator.next();
            if (!(infinityNBT instanceof NBTTagCompound) || ((NBTTagCompound)infinityNBT).func_74762_e("count") != 0) continue;
            infinityIterator.remove();
        }
    }
}

