/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.coremod.asm;

import aroma1997.core.coremod.MCPNames;
import aroma1997.core.coremod.asm.BasicTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodAnnotationInsertionTransformer
extends BasicTransformer {
    private List<String> methods = new ArrayList<String>();
    private List<String> fields = new ArrayList<String>();
    private HashMap<String, List<Object>> annotations = new HashMap();

    protected void addMethod(String name) {
        this.methods.add(MCPNames.method(name));
    }

    protected void addField(String name) {
        this.fields.add(MCPNames.field(name));
    }

    protected void addAnnotation(String clazz, List<Object> list) {
        this.annotations.put("L" + clazz.replace('.', '/') + ";", list);
    }

    @Override
    public void transform(ClassNode classNode) {
        AnnotationNode an;
        if (classNode.methods != null) {
            for (MethodNode mn : classNode.methods) {
                if (!this.methods.contains(mn.name)) continue;
                if (mn.visibleAnnotations == null) {
                    mn.visibleAnnotations = new ArrayList();
                }
                for (Map.Entry<String, List<Object>> e : this.annotations.entrySet()) {
                    an = new AnnotationNode(e.getKey());
                    an.values = e.getValue();
                    mn.visibleAnnotations.add(an);
                }
            }
        }
        if (classNode.fields != null) {
            for (FieldNode fn : classNode.fields) {
                if (!this.fields.contains(fn.name)) continue;
                if (fn.visibleAnnotations == null) {
                    fn.visibleAnnotations = new ArrayList();
                }
                for (Map.Entry<String, List<Object>> e : this.annotations.entrySet()) {
                    an = new AnnotationNode(e.getKey());
                    an.values = e.getValue();
                    fn.visibleAnnotations.add(an);
                }
            }
        }
    }
}

