/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.client.gui.elements;

import aroma1997.core.client.gui.GuiBase;
import aroma1997.core.client.gui.IRenderable;
import aroma1997.core.client.gui.elements.GuiElement;
import aroma1997.core.client.gui.elements.ILocationLookup;

public class GuiElementExpandable
extends GuiElement {
    private boolean expanding;
    private float expansionProgress;
    private long lastUpdate = System.currentTimeMillis();
    private final ILocationLookup minimized;
    private IRenderable content;

    public GuiElementExpandable(GuiBase<?> gui, final ILocationLookup minimized, final int maximizedWidth, final int maximizedHeight) {
        super(gui);
        this.minimized = minimized;
        this.location = new ILocationLookup(){

            @Override
            public int getX() {
                return minimized.getX();
            }

            @Override
            public int getY() {
                return minimized.getY();
            }

            @Override
            public int getWidth() {
                int minimizedWidth = minimized.getWidth();
                return minimizedWidth + (int)(GuiElementExpandable.this.expansionProgress * (float)(maximizedWidth - minimizedWidth));
            }

            @Override
            public int getHeight() {
                int minimizedHeight = minimized.getHeight();
                return minimizedHeight + (int)(GuiElementExpandable.this.expansionProgress * (float)(maximizedHeight - minimizedHeight));
            }
        };
    }

    public void setActualContent(IRenderable content) {
        this.content = content;
    }

    @Override
    public boolean onClick(int x, int y) {
        this.expanding = !this.expanding;
        return true;
    }

    @Override
    public void drawForegroundLayer(int x, int y) {
        long currentUpdate = System.currentTimeMillis();
        long diff = currentUpdate - this.lastUpdate;
        float multiplier = 0.003f;
        this.expansionProgress = this.expanding ? (this.expansionProgress += (float)diff * multiplier) : (this.expansionProgress -= (float)diff * multiplier);
        this.lastUpdate = currentUpdate;
        if (this.expansionProgress > 1.0f) {
            this.expansionProgress = 1.0f;
        } else if (this.expansionProgress < 0.0f) {
            this.expansionProgress = 0.0f;
        }
        this.draw(x, y);
        super.drawForegroundLayer(x, y);
    }

    protected void draw(int x, int y) {
        if (this.isFullyExpanded() && this.content != null) {
            this.content.render(this.getLocation().getX() + 2, this.getLocation().getY() + this.minimized.getHeight(), this.gui);
        }
    }

    public boolean isFullyExpanded() {
        return this.expansionProgress >= 1.0f;
    }
}

