/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.fugue.common;

import com.cleanroommc.fugue.common.Fugue;
import com.cleanroommc.fugue.config.FugueConfig;
import java.util.List;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.Loader;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.Config;

public class FugueMixinConfigPlugin
implements IMixinConfigPlugin {
    private Config config;

    public void onLoad(String mixinPackage) {
    }

    public void injectConfig(Config config) {
        this.config = config;
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return switch (mixinClassName.split("\\.")[4]) {
            case "charset" -> {
                if (Loader.isModLoaded((String)"charset") && FugueConfig.modPatchConfig.enableCharset) {
                    yield true;
                }
                yield false;
            }
            case "xaeroplus" -> {
                if (Loader.isModLoaded((String)"xaeroplus") && FugueConfig.modPatchConfig.enableXP) {
                    yield true;
                }
                yield false;
            }
            case "codechickenlib" -> {
                if (Launch.classLoader.isClassExist("codechicken.lib.CodeChickenLib") && FugueConfig.modPatchConfig.enableCCL) {
                    yield true;
                }
                yield false;
            }
            case "minecraftmultipartcbe" -> {
                if (Loader.isModLoaded((String)"minecraftmultipartcbe") && FugueConfig.modPatchConfig.enableMultiPart) {
                    yield true;
                }
                yield false;
            }
            case "projectred_core" -> {
                if (Loader.isModLoaded((String)"projectred-core") && FugueConfig.modPatchConfig.enablePR) {
                    yield true;
                }
                yield false;
            }
            case "solarflux" -> {
                if (Loader.isModLoaded((String)"solarflux") && FugueConfig.modPatchConfig.enableSolarFlux) {
                    yield true;
                }
                yield false;
            }
            case "custommainmenu" -> {
                if (Loader.isModLoaded((String)"custommainmenu") && FugueConfig.modPatchConfig.enableCMM) {
                    yield true;
                }
                yield false;
            }
            case "hammercore" -> {
                if (Loader.isModLoaded((String)"hammercore") && FugueConfig.modPatchConfig.enableHammerCore) {
                    yield true;
                }
                yield false;
            }
            case "gregtech" -> {
                if (Loader.isModLoaded((String)"gregtech") && FugueConfig.modPatchConfig.enableGTCEU && !Fugue.isModNewerThan("gregtech", "2.8.7")) {
                    yield true;
                }
                yield false;
            }
            case "mcjty" -> {
                if (Loader.isModLoaded((String)"mcjtylib_ng") && FugueConfig.modPatchConfig.enableMcjty) {
                    yield true;
                }
                yield false;
            }
            case "howlingmoon" -> {
                if (Loader.isModLoaded((String)"howlingmoon") && FugueConfig.modPatchConfig.enableHowlingMoon) {
                    yield true;
                }
                yield false;
            }
            case "customnpcs" -> {
                if (Loader.isModLoaded((String)"customnpcs") && FugueConfig.modPatchConfig.enableCustomNPC) {
                    yield true;
                }
                yield false;
            }
            case "waterpower" -> {
                if (Loader.isModLoaded((String)"waterpower") && FugueConfig.modPatchConfig.enableWaterPower) {
                    yield true;
                }
                yield false;
            }
            case "subaquatic" -> {
                if (Loader.isModLoaded((String)"subaquatic") && FugueConfig.modPatchConfig.enableSubaquatic) {
                    yield true;
                }
                yield false;
            }
            case "astralsorcery" -> {
                if (Loader.isModLoaded((String)"astralsorcery") && FugueConfig.modPatchConfig.enableAstralSorcery) {
                    yield true;
                }
                yield false;
            }
            case "armourers_workshop" -> {
                if (Loader.isModLoaded((String)"armourers_workshop") && FugueConfig.modPatchConfig.enableArmourersWorkshop) {
                    yield true;
                }
                yield false;
            }
            case "mage" -> {
                if (Loader.isModLoaded((String)"mage") && FugueConfig.modPatchConfig.enableMage) {
                    yield true;
                }
                yield false;
            }
            case "extrautils2" -> {
                if (Loader.isModLoaded((String)"extrautils2") && FugueConfig.modPatchConfig.enableExtraUtilities) {
                    yield true;
                }
                yield false;
            }
            case "incontrol" -> {
                if (Loader.isModLoaded((String)"incontrol") && FugueConfig.modPatchConfig.enableInControl) {
                    yield true;
                }
                yield false;
            }
            case "refinedstorage" -> {
                if (Loader.isModLoaded((String)"refinedstorage") && FugueConfig.modPatchConfig.enableMoreRefinedStorage && Fugue.isModNewerThan("refinedstorage", "2.0.0")) {
                    yield true;
                }
                yield false;
            }
            case "jei" -> {
                if (Loader.isModLoaded((String)"jei") && FugueConfig.modPatchConfig.enableHEI && Fugue.isModNewerThan("jei", "4.17.0")) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

