/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation.trie;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import top.outlands.foundation.trie.TrieNode;

abstract class AbstractTrie<V> {
    protected static int[] CHAR_TO_INDEX_MAP = TrieNode.CHAR_TO_INDEX_MAP;
    protected TrieNode<V> root = new TrieNode("", 0);
    protected int size;
    private boolean isAllAdded;

    protected AbstractTrie() {
    }

    public AbstractTrie(List<String> keys, List<V> values) {
        this();
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("IllegalArgumentException: the sizes of 'elements', 'values' and 'scores' should agree; elements.size() = " + keys.size() + ", values.size() = " + values.size());
        }
        boolean allAdded = true;
        for (int i = 0; i < keys.size(); ++i) {
            boolean added = this.put(keys.get(i), values.get(i));
            if (added) continue;
            allAdded = false;
        }
        this.isAllAdded = allAdded;
    }

    public boolean isAllAdded() {
        return this.isAllAdded;
    }

    private static int[] ones(int length) {
        int[] ones = new int[length];
        Arrays.fill(ones, 1);
        return ones;
    }

    protected int[] lookupIndices(char[] chars) {
        int[] result = new int[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            int index = this.charToIndex(chars[i]);
            if (index == -1) {
                return null;
            }
            result[i] = index;
        }
        return result;
    }

    public int size() {
        return this.size;
    }

    public TrieNode<V> getRoot() {
        return this.root;
    }

    protected final int charToIndex(char c) {
        return c >= CHAR_TO_INDEX_MAP.length ? -1 : CHAR_TO_INDEX_MAP[c];
    }

    public TrieNode<V> getNode(String word) {
        TrieNode<V> theNode = this.getNodeWithLongestCommonPart(word);
        return theNode != null && theNode.level == word.length() ? theNode : null;
    }

    public TrieNode<V> getNode(String word, int substringLength) {
        TrieNode<V> theNode = this.getNodeWithLongestCommonPart(word, substringLength);
        return theNode != null && theNode.level == word.length() ? theNode : null;
    }

    public TrieNode<V> getNodeWithLongestCommonPart(String word) {
        return this.getNodeWithLongestCommonPart(word, word.length());
    }

    public List<TrieNode<V>> getKeyValueNodes(String word) {
        return this.getKeyValueNodes(word, word.length());
    }

    protected List<TrieNode<V>> getKeyValueNodes(String word, int substringLength) {
        TrieNode<V> tempSubtreeRoot = this.getNodeWithLongestCommonPart(word, substringLength);
        if (tempSubtreeRoot.level < substringLength) {
            return Collections.emptyList();
        }
        return tempSubtreeRoot == null ? null : tempSubtreeRoot.getKeyValueNodes();
    }

    public List<TrieNode<V>> getKeyValueNodes(String word, Function<TrieNode<V>, Boolean> condition) {
        return this.getKeyValueNodes(word, word.length(), condition);
    }

    public List<TrieNode<V>> getKeyValueNodes(String word, int substringLength, Function<TrieNode<V>, Boolean> condition) {
        TrieNode<V> tempSubtreeRoot = this.getNodeWithLongestCommonPart(word, substringLength);
        if (tempSubtreeRoot.level < substringLength) {
            return Collections.emptyList();
        }
        return tempSubtreeRoot.getKeyValueNodes(condition);
    }

    public TrieNode<V> getKeyValueNode(String word) {
        TrieNode<V> theNode = this.getNodeWithLongestCommonPart(word);
        return theNode.isKeyValueNode && theNode.getKey().equals(word) ? theNode : null;
    }

    public TrieNode<V> getBestKeyValueNode(Comparator<TrieNode<V>> comparator) {
        return this.getRoot().getBestKeyValueNode(comparator);
    }

    public TrieNode<V> getBestKeyValueNode(String word, Comparator<TrieNode<V>> comparator) {
        return this.getBestKeyValueNode(word, word.length(), comparator);
    }

    protected TrieNode<V> getBestKeyValueNode(String word, int substringLength, Comparator<TrieNode<V>> comparator) {
        TrieNode<V> tempSubtreeRoot = this.getNodeWithLongestCommonPart(word, substringLength);
        if (tempSubtreeRoot.level < substringLength) {
            return null;
        }
        return tempSubtreeRoot == null ? null : tempSubtreeRoot.getBestKeyValueNode(comparator);
    }

    public List<TrieNode<V>> getBestKeyValueNodes(String word, int numTopKeyValueNodes, Comparator<TrieNode<V>> comparator) {
        return this.getBestKeyValueNodes(word, word.length(), numTopKeyValueNodes, comparator);
    }

    private List<TrieNode<V>> getBestKeyValueNodes(String word, int substringLength, int numTopKeyValueNodes, Comparator<TrieNode<V>> comparator) {
        TrieNode<V> tempSubtreeRoot = this.getNodeWithLongestCommonPart(word, substringLength);
        if (tempSubtreeRoot.level < substringLength) {
            return Collections.emptyList();
        }
        return tempSubtreeRoot == null ? null : tempSubtreeRoot.getBestKeyValueNodes(numTopKeyValueNodes, comparator);
    }

    protected abstract boolean put(String var1, V var2);

    protected abstract TrieNode<V> getNodeWithLongestCommonPart(String var1, int var2);
}

