/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation.transformer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import top.outlands.foundation.IExplicitTransformer;
import top.outlands.foundation.boot.Foundation;

public class ASMVisitorTransformer
implements IExplicitTransformer {
    private static final String CODE = "    if (api < 589824) {\n        this.api = 589824;\n        top.outlands.foundation.boot.Foundation.add(this.getClass().getName());\n    }\n";

    @Override
    public byte[] transform(byte[] basicClass) {
        try {
            CtClass cc = ClassPool.getDefault().makeClass((InputStream)new ByteArrayInputStream(basicClass));
            Foundation.LOGGER.debug("Patching " + cc.getName());
            CtConstructor cotr = cc.getConstructor("(I)V");
            cotr.insertAfter(CODE);
            cotr = switch (cc.getSimpleName()) {
                case "FieldVisitor" -> cc.getConstructor("(ILorg/objectweb/asm/FieldVisitor;)V");
                case "ClassVisitor" -> cc.getConstructor("(ILorg/objectweb/asm/ClassVisitor;)V");
                case "MethodVisitor" -> cc.getConstructor("(ILorg/objectweb/asm/MethodVisitor;)V");
                default -> throw new IllegalStateException("Unexpected value: " + cc.getSimpleName());
            };
            cotr.insertAfter(CODE);
            basicClass = cc.toBytecode();
        }
        catch (Throwable t) {
            Foundation.LOGGER.error((Object)t);
        }
        return basicClass;
    }
}

