/*
 * Decompiled with CFR 0.152.
 */
package top.outlands.foundation;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import net.minecraft.launchwrapper.ITweaker;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.asm.mixin.MixinEnvironment;
import top.outlands.foundation.TransformerDelegate;
import top.outlands.foundation.boot.Foundation;
import top.outlands.foundation.transformer.ASMClassWriterTransformer;
import top.outlands.foundation.transformer.ASMVisitorTransformer;

public class LaunchHandler {
    public void launch(String[] args) {
        OptionParser parser = new OptionParser();
        parser.allowsUnrecognizedOptions();
        ArgumentAcceptingOptionSpec profileOption = parser.accepts("version", "The version we launched with").withRequiredArg();
        ArgumentAcceptingOptionSpec gameDirOption = parser.accepts("gameDir", "Alternative game directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec assetsDirOption = parser.accepts("assetsDir", "Assets directory").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec tweakClassOption = parser.accepts("tweakClass", "Tweak class(es) to load").withRequiredArg();
        NonOptionArgumentSpec nonOption = parser.nonOptions();
        OptionSet options = parser.parse(args);
        Launch.minecraftHome = (File)options.valueOf((OptionSpec)gameDirOption);
        Launch.assetsDir = (File)options.valueOf((OptionSpec)assetsDirOption);
        String profileName = (String)options.valueOf((OptionSpec)profileOption);
        ArrayList tweakClassNames = new ArrayList(options.valuesOf((OptionSpec)tweakClassOption));
        ArrayList<String> argumentList = new ArrayList<String>();
        Launch.blackboard = new HashMap<String, Object>();
        Thread.currentThread().setContextClassLoader(Launch.classLoader);
        TransformerDelegate.fillTransformerHolder(Launch.classLoader.getTransformerHolder());
        TransformerDelegate.registerExplicitTransformerByInstance(new ASMVisitorTransformer(), "org.objectweb.asm.FieldVisitor", "org.objectweb.asm.ClassVisitor", "org.objectweb.asm.MethodVisitor");
        TransformerDelegate.registerExplicitTransformerByInstance(new ASMClassWriterTransformer(), "org.objectweb.asm.ClassWriter");
        try {
            Launch.classLoader.findClass("org.objectweb.asm.FieldVisitor");
            Launch.classLoader.findClass("org.objectweb.asm.ClassVisitor");
            Launch.classLoader.findClass("org.objectweb.asm.MethodVisitor");
            Launch.classLoader.findClass("org.objectweb.asm.ClassWriter");
        }
        catch (ClassNotFoundException e) {
            Foundation.LOGGER.error("Can't find ASM", (Throwable)e);
        }
        Launch.classLoader.addTransformerExclusion("org.objectweb.asm.");
        Launch.blackboard.put("TweakClasses", tweakClassNames);
        Launch.blackboard.put("ArgumentList", argumentList);
        HashSet<String> allTweakerNames = new HashSet<String>();
        ArrayList<Object> allTweakers = new ArrayList<Object>();
        try {
            ArrayList<ITweaker> tweakers = new ArrayList<ITweaker>(tweakClassNames.size() + 1);
            Launch.blackboard.put("Tweaks", tweakers);
            ITweaker primaryTweaker = null;
            do {
                Iterator it = tweakClassNames.iterator();
                while (it.hasNext()) {
                    String string = (String)it.next();
                    if (allTweakerNames.contains(string)) {
                        Foundation.LOGGER.warn("Tweak name {} has already been visited -- skipping", (Object)string);
                        it.remove();
                        continue;
                    }
                    allTweakerNames.add(string);
                    Foundation.LOGGER.info("Loading tweak name {}", (Object)string);
                    Launch.classLoader.addTransformerExclusion(string.substring(0, string.lastIndexOf(46)));
                    ITweaker tweaker = (ITweaker)Class.forName(string, true, Launch.classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
                    tweakers.add(tweaker);
                    it.remove();
                    if (primaryTweaker != null) continue;
                    Foundation.LOGGER.info("Using primary tweak name {}", (Object)string);
                    primaryTweaker = tweaker;
                }
                while (!tweakers.isEmpty()) {
                    ITweaker tweaker = (ITweaker)tweakers.getFirst();
                    Foundation.LOGGER.info("Calling tweak {}", (Object)tweaker.toString());
                    tweaker.acceptOptions(options.valuesOf((OptionSpec)nonOption), Launch.minecraftHome, Launch.assetsDir, profileName);
                    tweaker.injectIntoClassLoader(Launch.classLoader);
                    allTweakers.add(tweaker);
                    tweakers.remove(tweaker);
                }
            } while (!tweakClassNames.isEmpty());
            for (ITweaker iTweaker : allTweakers) {
                argumentList.addAll(Arrays.asList(iTweaker.getLaunchArguments()));
            }
            MixinEnvironment.gotoPhase((MixinEnvironment.Phase)MixinEnvironment.Phase.DEFAULT);
            String launchTarget = primaryTweaker.getLaunchTarget();
            Class<?> clazz = Class.forName(launchTarget, false, Launch.classLoader);
            Method mainMethod = clazz.getMethod("main", String[].class);
            Foundation.LOGGER.info("Launching wrapped minecraft {}", (Object)launchTarget);
            mainMethod.invoke(null, new Object[]{argumentList.toArray(new String[0])});
        }
        catch (Exception e) {
            Foundation.LOGGER.fatal("Unable to launch", (Throwable)e);
            System.exit(1);
        }
    }
}

