/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.openal;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl3.PointerBuffer;
import org.lwjgl3.openal.AL;
import org.lwjgl3.openal.SOFTEventProcI;
import org.lwjgl3.system.Checks;
import org.lwjgl3.system.CustomBuffer;
import org.lwjgl3.system.JNI;
import org.lwjgl3.system.MemoryUtil;
import org.lwjgl3.system.NativeType;

public class SOFTEvents {
    public static final int AL_EVENT_CALLBACK_FUNCTION_SOFT = 6562;
    public static final int AL_EVENT_CALLBACK_USER_PARAM_SOFT = 6563;
    public static final int AL_EVENT_TYPE_BUFFER_COMPLETED_SOFT = 6564;
    public static final int AL_EVENT_TYPE_SOURCE_STATE_CHANGED_SOFT = 6565;
    public static final int AL_EVENT_TYPE_DISCONNECTED_SOFT = 6566;

    protected SOFTEvents() {
        throw new UnsupportedOperationException();
    }

    public static void nalEventControlSOFT(int count, long types, boolean enable) {
        long __functionAddress = AL.getICD().alEventControlSOFT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePV((int)count, (long)types, (boolean)enable, (long)__functionAddress);
    }

    public static void alEventControlSOFT(@NativeType(value="ALenum const *") IntBuffer types, @NativeType(value="ALboolean") boolean enable) {
        SOFTEvents.nalEventControlSOFT(types.remaining(), MemoryUtil.memAddress((IntBuffer)types), enable);
    }

    public static void nalEventCallbackSOFT(long callback, long userParam) {
        long __functionAddress = AL.getICD().alEventCallbackSOFT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePPV((long)callback, (long)userParam, (long)__functionAddress);
    }

    public static void alEventCallbackSOFT(@NativeType(value="ALEVENTPROCSOFT") SOFTEventProcI callback, @Nullable @NativeType(value="ALvoid *") ByteBuffer userParam) {
        SOFTEvents.nalEventCallbackSOFT(callback.address(), MemoryUtil.memAddressSafe((ByteBuffer)userParam));
    }

    @NativeType(value="ALvoid *")
    public static long alGetPointerSOFT(@NativeType(value="ALenum") int pname) {
        long __functionAddress = AL.getICD().alGetPointerSOFT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokeP((int)pname, (long)__functionAddress);
    }

    public static void nalGetPointervSOFT(int pname, long values) {
        long __functionAddress = AL.getICD().alGetPointervSOFT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePV((int)pname, (long)values, (long)__functionAddress);
    }

    public static void alGetPointervSOFT(@NativeType(value="ALenum") int pname, @NativeType(value="ALvoid **") PointerBuffer values) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)values, (int)1);
        }
        SOFTEvents.nalGetPointervSOFT(pname, MemoryUtil.memAddress((CustomBuffer)values));
    }

    public static void alEventControlSOFT(@NativeType(value="ALenum const *") int[] types, @NativeType(value="ALboolean") boolean enable) {
        long __functionAddress = AL.getICD().alEventControlSOFT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePV((int)types.length, (int[])types, (boolean)enable, (long)__functionAddress);
    }
}

