/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.openal;

import java.nio.LongBuffer;
import org.lwjgl3.openal.ALC;
import org.lwjgl3.system.Checks;
import org.lwjgl3.system.JNI;
import org.lwjgl3.system.MemoryStack;
import org.lwjgl3.system.MemoryUtil;
import org.lwjgl3.system.NativeType;

public class SOFTDeviceClock {
    public static final int ALC_DEVICE_CLOCK_SOFT = 5632;
    public static final int ALC_DEVICE_LATENCY_SOFT = 5633;
    public static final int ALC_DEVICE_CLOCK_LATENCY_SOFT = 5634;
    public static final int AL_SAMPLE_OFFSET_CLOCK_SOFT = 4610;
    public static final int AL_SEC_OFFSET_CLOCK_SOFT = 4611;

    protected SOFTDeviceClock() {
        throw new UnsupportedOperationException();
    }

    public static void nalcGetInteger64vSOFT(long device, int pname, int size, long values) {
        long __functionAddress = ALC.getICD().alcGetInteger64vSOFT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePPV((long)device, (int)pname, (int)size, (long)values, (long)__functionAddress);
    }

    @NativeType(value="ALCvoid")
    public static void alcGetInteger64vSOFT(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCenum") int pname, @NativeType(value="ALCint64SOFT *") LongBuffer values) {
        SOFTDeviceClock.nalcGetInteger64vSOFT(device, pname, values.remaining(), MemoryUtil.memAddress((LongBuffer)values));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="ALCvoid")
    public static long alcGetInteger64vSOFT(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCenum") int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            LongBuffer values = stack.callocLong(1);
            SOFTDeviceClock.nalcGetInteger64vSOFT(device, pname, 1, MemoryUtil.memAddress((LongBuffer)values));
            long l = values.get(0);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="ALCvoid")
    public static void alcGetInteger64vSOFT(@NativeType(value="ALCdevice *") long device, @NativeType(value="ALCenum") int pname, @NativeType(value="ALCint64SOFT *") long[] values) {
        long __functionAddress = ALC.getICD().alcGetInteger64vSOFT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePPV((long)device, (int)pname, (int)values.length, (long[])values, (long)__functionAddress);
    }
}

