/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.glfw;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl3.glfw.GLFW;
import org.lwjgl3.system.APIUtil;
import org.lwjgl3.system.Checks;
import org.lwjgl3.system.FunctionProvider;
import org.lwjgl3.system.JNI;
import org.lwjgl3.system.MemoryUtil;
import org.lwjgl3.system.NativeType;
import org.lwjgl3.system.SharedLibrary;

public class GLFWNativeGLX {
    protected GLFWNativeGLX() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="GLXContext")
    public static long glfwGetGLXContext(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetGLXContext;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="GLXWindow")
    public static long glfwGetGLXWindow(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetGLXWindow;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="GLXWindow")
    public static long glfwGetGLXFBConfig(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetGLXFBConfig;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    public static void setPath(FunctionProvider sharedLibrary) {
        if (!(sharedLibrary instanceof SharedLibrary)) {
            APIUtil.apiLog((CharSequence)"GLFW OpenGL path override not set: Function provider is not a shared library.");
            return;
        }
        String path = ((SharedLibrary)sharedLibrary).getPath();
        if (path == null) {
            APIUtil.apiLog((CharSequence)"GLFW OpenGL path override not set: Could not resolve the shared library path.");
            return;
        }
        GLFWNativeGLX.setPath(path);
    }

    public static void setPath(@Nullable String path) {
        long override = GLFW.getLibrary().getFunctionAddress((CharSequence)"_glfw_opengl_library");
        if (override == 0L) {
            APIUtil.apiLog((CharSequence)"GLFW OpenGL path override not set: Could not resolve override symbol.");
            return;
        }
        long a = MemoryUtil.memGetAddress((long)override);
        if (a != 0L) {
            MemoryUtil.nmemFree((long)a);
        }
        MemoryUtil.memPutAddress((long)override, (long)(path == null ? 0L : MemoryUtil.memAddress((ByteBuffer)MemoryUtil.memUTF8((CharSequence)path))));
    }

    public static final class Functions {
        public static final long GetGLXContext = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetGLXContext");
        public static final long GetGLXWindow = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetGLXWindow");
        public static final long GetGLXFBConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetGLXFBConfig");

        private Functions() {
        }
    }
}

