/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.glfw;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl3.glfw.GLFW;
import org.lwjgl3.system.APIUtil;
import org.lwjgl3.system.Checks;
import org.lwjgl3.system.FunctionProvider;
import org.lwjgl3.system.JNI;
import org.lwjgl3.system.MemoryUtil;
import org.lwjgl3.system.NativeType;
import org.lwjgl3.system.SharedLibrary;

public class GLFWNativeEGL {
    protected GLFWNativeEGL() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="EGLDisplay")
    public static long glfwGetEGLDisplay() {
        long __functionAddress = Functions.GetEGLDisplay;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="EGLContext")
    public static long glfwGetEGLContext(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetEGLContext;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="EGLSurface")
    public static long glfwGetEGLSurface(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetEGLSurface;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    @NativeType(value="EGLConfig")
    public static long glfwGetEGLConfig(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetEGLConfig;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)window, (long)__functionAddress);
    }

    public static void setEGLPath(FunctionProvider sharedLibrary) {
        if (!(sharedLibrary instanceof SharedLibrary)) {
            APIUtil.apiLog((CharSequence)"GLFW EGL path override not set: Function provider is not a shared library.");
            return;
        }
        String path = ((SharedLibrary)sharedLibrary).getPath();
        if (path == null) {
            APIUtil.apiLog((CharSequence)"GLFW EGL path override not set: Could not resolve the shared library path.");
            return;
        }
        GLFWNativeEGL.setEGLPath(path);
    }

    public static void setEGLPath(@Nullable String path) {
        if (!GLFWNativeEGL.override("_glfw_egl_library", path)) {
            APIUtil.apiLog((CharSequence)"GLFW EGL path override not set: Could not resolve override symbol.");
        }
    }

    public static void setGLESPath(FunctionProvider sharedLibrary) {
        if (!(sharedLibrary instanceof SharedLibrary)) {
            APIUtil.apiLog((CharSequence)"GLFW OpenGL ES path override not set: Function provider is not a shared library.");
            return;
        }
        String path = ((SharedLibrary)sharedLibrary).getPath();
        if (path == null) {
            APIUtil.apiLog((CharSequence)"GLFW OpenGL ES path override not set: Could not resolve the shared library path.");
            return;
        }
        GLFWNativeEGL.setGLESPath(path);
    }

    public static void setGLESPath(@Nullable String path) {
        if (!GLFWNativeEGL.override("_glfw_opengles_library", path)) {
            APIUtil.apiLog((CharSequence)"GLFW OpenGL ES path override not set: Could not resolve override symbol.");
        }
    }

    private static boolean override(String symbol, @Nullable String path) {
        long override = GLFW.getLibrary().getFunctionAddress((CharSequence)symbol);
        if (override == 0L) {
            return false;
        }
        long a = MemoryUtil.memGetAddress((long)override);
        if (a != 0L) {
            MemoryUtil.nmemFree((long)a);
        }
        MemoryUtil.memPutAddress((long)override, (long)(path == null ? 0L : MemoryUtil.memAddress((ByteBuffer)MemoryUtil.memUTF8((CharSequence)path))));
        return true;
    }

    public static final class Functions {
        public static final long GetEGLDisplay = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetEGLDisplay");
        public static final long GetEGLContext = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetEGLContext");
        public static final long GetEGLSurface = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetEGLSurface");
        public static final long GetEGLConfig = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetEGLConfig");

        private Functions() {
        }
    }
}

