/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl3.glfw;

import org.lwjgl3.system.Configuration;
import org.lwjgl3.system.JNI;
import org.lwjgl3.system.Platform;
import org.lwjgl3.system.macosx.LibC;
import org.lwjgl3.system.macosx.ObjCRuntime;

final class EventLoop {
    private EventLoop() {
    }

    static void check() {
        if (Platform.get() == Platform.MACOSX && !EventLoop.isMainThread()) {
            throw new IllegalStateException(EventLoop.isJavaStartedOnFirstThread() ? "GLFW may only be used on the main thread. This check may be disabled with Configuration.GLFW_CHECK_THREAD0." : "GLFW may only be used on the main thread and that thread must be the first thread in the process. Please run the JVM with -XstartOnFirstThread. This check may be disabled with Configuration.GLFW_CHECK_THREAD0.");
        }
    }

    private static boolean isMainThread() {
        if (!((Boolean)Configuration.GLFW_CHECK_THREAD0.get((Object)true)).booleanValue() || ((String)Configuration.GLFW_LIBRARY_NAME.get((Object)"")).contains("glfw_async")) {
            return true;
        }
        long objc_msgSend = ObjCRuntime.getLibrary().getFunctionAddress((CharSequence)"objc_msgSend");
        long NSThread = ObjCRuntime.objc_getClass((CharSequence)"NSThread");
        long currentThread = JNI.invokePPP((long)NSThread, (long)ObjCRuntime.sel_getUid((CharSequence)"currentThread"), (long)objc_msgSend);
        return JNI.invokePPZ((long)currentThread, (long)ObjCRuntime.sel_getUid((CharSequence)"isMainThread"), (long)objc_msgSend);
    }

    private static boolean isJavaStartedOnFirstThread() {
        return "1".equals(System.getenv().get("JAVA_STARTED_ON_FIRST_THREAD_" + LibC.getpid()));
    }
}

