/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.asm.mixin.gen;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.gen.AccessorGeneratorField;
import org.spongepowered.asm.mixin.gen.AccessorInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.MixinTargetContext;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Bytecode;

public class AccessorGeneratorFieldGetter
extends AccessorGeneratorField {
    private boolean mutable;

    public AccessorGeneratorFieldGetter(AccessorInfo info) {
        super(info);
    }

    @Override
    public void validate() {
        super.validate();
        ClassInfo.Method method = this.info.getClassInfo().findMethod(this.info.getMethod());
        this.mutable = method.isDecoratedMutable();
        if (this.mutable || !Bytecode.hasFlag(this.targetField, 16)) {
            return;
        }
        if (this.info.getMixin().getOption(MixinEnvironment.Option.DEBUG_VERBOSE)) {
            MixinService.getService().getLogger("mixin").warn("{} for final field {}::{} is not @Mutable. This won't work on newer Java, automatically stripping...", this.info, ((MixinTargetContext)this.info.getMixin()).getTarget(), this.targetField.name);
        }
    }

    @Override
    public MethodNode generate() {
        if (this.mutable) {
            this.targetField.access &= 0xFFFFFFEF;
        } else if ((this.targetField.access & 0x10) != 0) {
            this.targetField.access &= 0xFFFFFFEF;
        }
        MethodNode method = this.createMethod(this.targetType.getSize(), this.targetType.getSize());
        if (!this.targetIsStatic) {
            method.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        int opcode = this.targetIsStatic ? 178 : 180;
        method.instructions.add((AbstractInsnNode)new FieldInsnNode(opcode, this.info.getClassNode().name, this.targetField.name, this.targetField.desc));
        method.instructions.add((AbstractInsnNode)new InsnNode(this.targetType.getOpcode(172)));
        return method;
    }
}

