/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.glu;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.glu.Util;
import org.lwjgl3.opengl.GL11;
import org.lwjgl3.stb.STBImageResize;

public class MipMap
extends Util {
    public static int gluBuild2DMipmaps(int target, int components, int width, int height, int format, int type, ByteBuffer data) {
        ByteBuffer image;
        int h2;
        if (width < 1 || height < 1) {
            return 100901;
        }
        int bpp = MipMap.bytesPerPixel(format, type);
        if (bpp == 0) {
            return 100900;
        }
        int maxSize = MipMap.glGetIntegerv(3379);
        int w = MipMap.nearestPower(width);
        if (w > maxSize) {
            w = maxSize;
        }
        if ((h2 = MipMap.nearestPower(height)) > maxSize) {
            h2 = maxSize;
        }
        int retVal = 0;
        boolean done = false;
        if (w != width || h2 != height) {
            image = BufferUtils.createByteBuffer((w + 4) * h2 * bpp);
            int error = MipMap.gluScaleImage(format, width, height, type, data, w, h2, type, image);
            if (error != 0) {
                retVal = error;
                done = true;
            }
        } else {
            image = data;
        }
        ByteBuffer bufferA = null;
        ByteBuffer bufferB = null;
        int level = 0;
        while (!done) {
            int newH;
            GL11.glTexImage2D((int)target, (int)level, (int)components, (int)w, (int)h2, (int)0, (int)format, (int)type, (ByteBuffer)image);
            if (w == 1 && h2 == 1) break;
            int newW = w < 2 ? 1 : w >> 1;
            int n2 = newH = h2 < 2 ? 1 : h2 >> 1;
            ByteBuffer newImage = bufferA == null ? (bufferA = BufferUtils.createByteBuffer((newW + 4) * newH * bpp)) : (bufferB == null ? (bufferB = BufferUtils.createByteBuffer((newW + 4) * newH * bpp)) : bufferB);
            int error = MipMap.gluScaleImage(format, w, h2, type, image, newW, newH, type, newImage);
            if (error != 0) {
                retVal = error;
                done = true;
            }
            image = newImage;
            if (bufferB != null) {
                bufferB = bufferA;
            }
            w = newW;
            h2 = newH;
            ++level;
        }
        return retVal;
    }

    public static int gluScaleImage(int format, int widthIn, int heightIn, int typein, ByteBuffer dataIn, int widthOut, int heightOut, int typeOut, ByteBuffer dataOut) {
        int components = MipMap.compPerPix(format);
        int alphaIdx = MipMap.formatAlphaIndex(format);
        if (components == -1) {
            return 100900;
        }
        int strideIn = widthIn * components;
        int strideOut = widthOut * components;
        if (typein != typeOut) {
            return 100900;
        }
        switch (typein) {
            case 5121: {
                if (null != STBImageResize.stbir_resize_uint8_srgb((ByteBuffer)dataIn, (int)widthIn, (int)heightIn, (int)strideIn, (ByteBuffer)dataOut, (int)widthOut, (int)heightOut, (int)strideOut, (int)0)) break;
                throw new RuntimeException("Couldn't resize image with stbir");
            }
            case 5126: {
                if (null == STBImageResize.stbir_resize_float_linear((FloatBuffer)dataIn.asFloatBuffer(), (int)widthIn, (int)heightIn, (int)(strideIn * 4), (FloatBuffer)dataOut.asFloatBuffer(), (int)widthOut, (int)heightOut, (int)(strideOut * 4), (int)0)) break;
                throw new RuntimeException("Couldn't resize image with stbir");
            }
            default: {
                return 1280;
            }
        }
        return 0;
    }
}

