/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.io.Serializable;
import org.lwjgl.util.ReadableDimension;
import org.lwjgl.util.ReadablePoint;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.WritableDimension;
import org.lwjgl.util.WritablePoint;
import org.lwjgl.util.WritableRectangle;

public final class Rectangle
implements ReadableRectangle,
WritableRectangle,
Serializable {
    static final long serialVersionUID = 1L;
    private int x;
    private int y;
    private int width;
    private int height;

    public Rectangle() {
    }

    public Rectangle(int x, int y, int w, int h2) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h2;
    }

    public Rectangle(ReadablePoint p2, ReadableDimension d2) {
        this.x = p2.getX();
        this.y = p2.getY();
        this.width = d2.getWidth();
        this.height = d2.getHeight();
    }

    public Rectangle(ReadableRectangle r2) {
        this.x = r2.getX();
        this.y = r2.getY();
        this.width = r2.getWidth();
        this.height = r2.getHeight();
    }

    @Override
    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setLocation(ReadablePoint p2) {
        this.x = p2.getX();
        this.y = p2.getY();
    }

    @Override
    public void setSize(int w, int h2) {
        this.width = w;
        this.height = h2;
    }

    @Override
    public void setSize(ReadableDimension d2) {
        this.width = d2.getWidth();
        this.height = d2.getHeight();
    }

    @Override
    public void setBounds(int x, int y, int w, int h2) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h2;
    }

    @Override
    public void setBounds(ReadablePoint p2, ReadableDimension d2) {
        this.x = p2.getX();
        this.y = p2.getY();
        this.width = d2.getWidth();
        this.height = d2.getHeight();
    }

    @Override
    public void setBounds(ReadableRectangle r2) {
        this.x = r2.getX();
        this.y = r2.getY();
        this.width = r2.getWidth();
        this.height = r2.getHeight();
    }

    @Override
    public void getBounds(WritableRectangle dest) {
        dest.setBounds(this.x, this.y, this.width, this.height);
    }

    @Override
    public void getLocation(WritablePoint dest) {
        dest.setLocation(this.x, this.y);
    }

    @Override
    public void getSize(WritableDimension dest) {
        dest.setSize(this.width, this.height);
    }

    public void translate(int x, int y) {
        this.x += x;
        this.y += y;
    }

    public void translate(ReadablePoint point) {
        this.x += point.getX();
        this.y += point.getY();
    }

    public void untranslate(ReadablePoint point) {
        this.x -= point.getX();
        this.y -= point.getY();
    }

    public boolean contains(ReadablePoint p2) {
        return this.contains(p2.getX(), p2.getY());
    }

    public boolean contains(int X, int Y) {
        int w = this.width;
        int h2 = this.height;
        if ((w | h2) < 0) {
            return false;
        }
        int x = this.x;
        int y = this.y;
        if (X < x || Y < y) {
            return false;
        }
        h2 += y;
        return !((w += x) >= x && w <= X || h2 >= y && h2 <= Y);
    }

    public boolean contains(ReadableRectangle r2) {
        return this.contains(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
    }

    public boolean contains(int X, int Y, int W, int H) {
        int w = this.width;
        int h2 = this.height;
        if ((w | h2 | W | H) < 0) {
            return false;
        }
        int x = this.x;
        int y = this.y;
        if (X < x || Y < y) {
            return false;
        }
        w += x;
        if ((W += X) <= X ? w >= x || W > w : w >= x && W > w) {
            return false;
        }
        h2 += y;
        return !((H += Y) <= Y ? h2 >= y || H > h2 : h2 >= y && H > h2);
    }

    public boolean intersects(ReadableRectangle r2) {
        int tw = this.width;
        int th = this.height;
        int rw2 = r2.getWidth();
        int rh = r2.getHeight();
        if (rw2 <= 0 || rh <= 0 || tw <= 0 || th <= 0) {
            return false;
        }
        int tx = this.x;
        int ty = this.y;
        int rx2 = r2.getX();
        int ry2 = r2.getY();
        rh += ry2;
        tw += tx;
        th += ty;
        return !((rw2 += rx2) >= rx2 && rw2 <= tx || rh >= ry2 && rh <= ty || tw >= tx && tw <= rx2 || th >= ty && th <= ry2);
    }

    public Rectangle intersection(ReadableRectangle r2, Rectangle dest) {
        int tx1 = this.x;
        int ty1 = this.y;
        int rx1 = r2.getX();
        int ry1 = r2.getY();
        long tx2 = tx1;
        tx2 += (long)this.width;
        long ty2 = ty1;
        ty2 += (long)this.height;
        long rx2 = rx1;
        rx2 += (long)r2.getWidth();
        long ry2 = ry1;
        ry2 += (long)r2.getHeight();
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= (long)ty1;
        if ((tx2 -= (long)tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        if (dest == null) {
            dest = new Rectangle(tx1, ty1, (int)tx2, (int)ty2);
        } else {
            dest.setBounds(tx1, ty1, (int)tx2, (int)ty2);
        }
        return dest;
    }

    public WritableRectangle union(ReadableRectangle r2, WritableRectangle dest) {
        int x1 = Math.min(this.x, r2.getX());
        int x2 = Math.max(this.x + this.width, r2.getX() + r2.getWidth());
        int y1 = Math.min(this.y, r2.getY());
        int y2 = Math.max(this.y + this.height, r2.getY() + r2.getHeight());
        dest.setBounds(x1, y1, x2 - x1, y2 - y1);
        return dest;
    }

    public void add(int newx, int newy) {
        int x1 = Math.min(this.x, newx);
        int x2 = Math.max(this.x + this.width, newx);
        int y1 = Math.min(this.y, newy);
        int y2 = Math.max(this.y + this.height, newy);
        this.x = x1;
        this.y = y1;
        this.width = x2 - x1;
        this.height = y2 - y1;
    }

    public void add(ReadablePoint pt) {
        this.add(pt.getX(), pt.getY());
    }

    public void add(ReadableRectangle r2) {
        int x1 = Math.min(this.x, r2.getX());
        int x2 = Math.max(this.x + this.width, r2.getX() + r2.getWidth());
        int y1 = Math.min(this.y, r2.getY());
        int y2 = Math.max(this.y + this.height, r2.getY() + r2.getHeight());
        this.x = x1;
        this.y = y1;
        this.width = x2 - x1;
        this.height = y2 - y1;
    }

    public void grow(int h2, int v) {
        this.x -= h2;
        this.y -= v;
        this.width += h2 * 2;
        this.height += v * 2;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle r2 = (Rectangle)obj;
            return this.x == r2.x && this.y == r2.y && this.width == r2.width && this.height == r2.height;
        }
        return super.equals(obj);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }
}

