/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.lwjgl.util.ReadableColor;
import org.lwjgl.util.WritableColor;

public final class Color
implements ReadableColor,
Serializable,
WritableColor {
    static final long serialVersionUID = 1L;
    private byte red;
    private byte green;
    private byte blue;
    private byte alpha;

    public Color() {
        this(0, 0, 0, 255);
    }

    public Color(int r2, int g, int b2) {
        this(r2, g, b2, 255);
    }

    public Color(byte r2, byte g, byte b2) {
        this(r2, g, b2, -1);
    }

    public Color(int r2, int g, int b2, int a2) {
        this.set(r2, g, b2, a2);
    }

    public Color(byte r2, byte g, byte b2, byte a2) {
        this.set(r2, g, b2, a2);
    }

    public Color(ReadableColor c2) {
        this.setColor(c2);
    }

    @Override
    public void set(int r2, int g, int b2, int a2) {
        this.red = (byte)r2;
        this.green = (byte)g;
        this.blue = (byte)b2;
        this.alpha = (byte)a2;
    }

    @Override
    public void set(byte r2, byte g, byte b2, byte a2) {
        this.red = r2;
        this.green = g;
        this.blue = b2;
        this.alpha = a2;
    }

    @Override
    public void set(int r2, int g, int b2) {
        this.set(r2, g, b2, 255);
    }

    @Override
    public void set(byte r2, byte g, byte b2) {
        this.set(r2, g, b2, (byte)-1);
    }

    @Override
    public int getRed() {
        return this.red & 0xFF;
    }

    @Override
    public int getGreen() {
        return this.green & 0xFF;
    }

    @Override
    public int getBlue() {
        return this.blue & 0xFF;
    }

    @Override
    public int getAlpha() {
        return this.alpha & 0xFF;
    }

    @Override
    public void setRed(int red) {
        this.red = (byte)red;
    }

    @Override
    public void setGreen(int green) {
        this.green = (byte)green;
    }

    @Override
    public void setBlue(int blue) {
        this.blue = (byte)blue;
    }

    @Override
    public void setAlpha(int alpha) {
        this.alpha = (byte)alpha;
    }

    @Override
    public void setRed(byte red) {
        this.red = red;
    }

    @Override
    public void setGreen(byte green) {
        this.green = green;
    }

    @Override
    public void setBlue(byte blue) {
        this.blue = blue;
    }

    @Override
    public void setAlpha(byte alpha) {
        this.alpha = alpha;
    }

    public String toString() {
        return "Color [" + this.getRed() + ", " + this.getGreen() + ", " + this.getBlue() + ", " + this.getAlpha() + "]";
    }

    public boolean equals(Object o) {
        return o != null && o instanceof ReadableColor && ((ReadableColor)o).getRed() == this.getRed() && ((ReadableColor)o).getGreen() == this.getGreen() && ((ReadableColor)o).getBlue() == this.getBlue() && ((ReadableColor)o).getAlpha() == this.getAlpha();
    }

    public int hashCode() {
        return this.red << 24 | this.green << 16 | this.blue << 8 | this.alpha;
    }

    @Override
    public byte getAlphaByte() {
        return this.alpha;
    }

    @Override
    public byte getBlueByte() {
        return this.blue;
    }

    @Override
    public byte getGreenByte() {
        return this.green;
    }

    @Override
    public byte getRedByte() {
        return this.red;
    }

    @Override
    public void writeRGBA(ByteBuffer dest) {
        dest.put(this.red);
        dest.put(this.green);
        dest.put(this.blue);
        dest.put(this.alpha);
    }

    @Override
    public void writeRGB(ByteBuffer dest) {
        dest.put(this.red);
        dest.put(this.green);
        dest.put(this.blue);
    }

    @Override
    public void writeABGR(ByteBuffer dest) {
        dest.put(this.alpha);
        dest.put(this.blue);
        dest.put(this.green);
        dest.put(this.red);
    }

    @Override
    public void writeARGB(ByteBuffer dest) {
        dest.put(this.alpha);
        dest.put(this.red);
        dest.put(this.green);
        dest.put(this.blue);
    }

    @Override
    public void writeBGR(ByteBuffer dest) {
        dest.put(this.blue);
        dest.put(this.green);
        dest.put(this.red);
    }

    @Override
    public void writeBGRA(ByteBuffer dest) {
        dest.put(this.blue);
        dest.put(this.green);
        dest.put(this.red);
        dest.put(this.alpha);
    }

    @Override
    public void readRGBA(ByteBuffer src) {
        this.red = src.get();
        this.green = src.get();
        this.blue = src.get();
        this.alpha = src.get();
    }

    @Override
    public void readRGB(ByteBuffer src) {
        this.red = src.get();
        this.green = src.get();
        this.blue = src.get();
    }

    @Override
    public void readARGB(ByteBuffer src) {
        this.alpha = src.get();
        this.red = src.get();
        this.green = src.get();
        this.blue = src.get();
    }

    @Override
    public void readBGRA(ByteBuffer src) {
        this.blue = src.get();
        this.green = src.get();
        this.red = src.get();
        this.alpha = src.get();
    }

    @Override
    public void readBGR(ByteBuffer src) {
        this.blue = src.get();
        this.green = src.get();
        this.red = src.get();
    }

    @Override
    public void readABGR(ByteBuffer src) {
        this.alpha = src.get();
        this.blue = src.get();
        this.green = src.get();
        this.red = src.get();
    }

    @Override
    public void setColor(ReadableColor src) {
        this.red = src.getRedByte();
        this.green = src.getGreenByte();
        this.blue = src.getBlueByte();
        this.alpha = src.getAlphaByte();
    }

    public void fromHSB(float hue, float saturation, float brightness) {
        if (saturation == 0.0f) {
            this.green = this.blue = (byte)(brightness * 255.0f + 0.5f);
            this.red = this.blue;
        } else {
            float f3 = (hue - (float)Math.floor(hue)) * 6.0f;
            float f4 = f3 - (float)Math.floor(f3);
            float f5 = brightness * (1.0f - saturation);
            float f6 = brightness * (1.0f - saturation * f4);
            float f7 = brightness * (1.0f - saturation * (1.0f - f4));
            switch ((int)f3) {
                case 0: {
                    this.red = (byte)(brightness * 255.0f + 0.5f);
                    this.green = (byte)(f7 * 255.0f + 0.5f);
                    this.blue = (byte)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    this.red = (byte)(f6 * 255.0f + 0.5f);
                    this.green = (byte)(brightness * 255.0f + 0.5f);
                    this.blue = (byte)(f5 * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    this.red = (byte)(f5 * 255.0f + 0.5f);
                    this.green = (byte)(brightness * 255.0f + 0.5f);
                    this.blue = (byte)(f7 * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    this.red = (byte)(f5 * 255.0f + 0.5f);
                    this.green = (byte)(f6 * 255.0f + 0.5f);
                    this.blue = (byte)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    this.red = (byte)(f7 * 255.0f + 0.5f);
                    this.green = (byte)(f5 * 255.0f + 0.5f);
                    this.blue = (byte)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    this.red = (byte)(brightness * 255.0f + 0.5f);
                    this.green = (byte)(f5 * 255.0f + 0.5f);
                    this.blue = (byte)(f6 * 255.0f + 0.5f);
                }
            }
        }
    }

    public float[] toHSB(float[] dest) {
        float hue;
        int i1;
        int l2;
        int r2 = this.getRed();
        int g = this.getGreen();
        int b2 = this.getBlue();
        if (dest == null) {
            dest = new float[3];
        }
        int n2 = l2 = r2 <= g ? g : r2;
        if (b2 > l2) {
            l2 = b2;
        }
        int n3 = i1 = r2 >= g ? g : r2;
        if (b2 < i1) {
            i1 = b2;
        }
        float brightness = (float)l2 / 255.0f;
        float saturation = l2 != 0 ? (float)(l2 - i1) / (float)l2 : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float f3 = (float)(l2 - r2) / (float)(l2 - i1);
            float f4 = (float)(l2 - g) / (float)(l2 - i1);
            float f5 = (float)(l2 - b2) / (float)(l2 - i1);
            hue = r2 == l2 ? f5 - f4 : (g == l2 ? 2.0f + f3 - f5 : 4.0f + f4 - f3);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        dest[0] = hue;
        dest[1] = saturation;
        dest[2] = brightness;
        return dest;
    }
}

