/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.spaceinvaders;

import java.io.IOException;
import org.lwjgl.test.spaceinvaders.Texture;
import org.lwjgl.test.spaceinvaders.TextureLoader;
import org.lwjgl3.opengl.GL11;

public class Sprite {
    private Texture texture;
    private int width;
    private int height;

    public Sprite(TextureLoader loader, String ref) {
        try {
            this.texture = loader.getTexture("spaceinvaders/" + ref);
            this.width = this.texture.getImageWidth();
            this.height = this.texture.getImageHeight();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            System.exit(-1);
        }
    }

    public int getWidth() {
        return this.texture.getImageWidth();
    }

    public int getHeight() {
        return this.texture.getImageHeight();
    }

    public void draw(int x, int y) {
        GL11.glPushMatrix();
        this.texture.bind();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex2f((float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)this.texture.getHeight());
        GL11.glVertex2f((float)0.0f, (float)this.height);
        GL11.glTexCoord2f((float)this.texture.getWidth(), (float)this.texture.getHeight());
        GL11.glVertex2f((float)this.width, (float)this.height);
        GL11.glTexCoord2f((float)this.texture.getWidth(), (float)0.0f);
        GL11.glVertex2f((float)this.width, (float)0.0f);
        GL11.glEnd();
        GL11.glPopMatrix();
    }
}

