/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.awt.Canvas;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraftforge.common.ForgeEarlyConfig;
import org.lwjgl.BufferUtils;
import org.lwjgl.Sys;
import org.lwjgl.input.KeyCodes;
import org.lwjgl.input.KeyEvent;
import org.lwjgl.input.KeyState;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ContextAttribs;
import org.lwjgl.opengl.DisplayImplementation;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.Drawable;
import org.lwjgl.opengl.DrawableGL;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.Sync;
import org.lwjgl3.glfw.GLFW;
import org.lwjgl3.glfw.GLFWCharCallback;
import org.lwjgl3.glfw.GLFWCharCallbackI;
import org.lwjgl3.glfw.GLFWCharModsCallback;
import org.lwjgl3.glfw.GLFWCharModsCallbackI;
import org.lwjgl3.glfw.GLFWCursorPosCallback;
import org.lwjgl3.glfw.GLFWCursorPosCallbackI;
import org.lwjgl3.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl3.glfw.GLFWFramebufferSizeCallbackI;
import org.lwjgl3.glfw.GLFWImage;
import org.lwjgl3.glfw.GLFWKeyCallback;
import org.lwjgl3.glfw.GLFWKeyCallbackI;
import org.lwjgl3.glfw.GLFWMouseButtonCallback;
import org.lwjgl3.glfw.GLFWMouseButtonCallbackI;
import org.lwjgl3.glfw.GLFWScrollCallback;
import org.lwjgl3.glfw.GLFWScrollCallbackI;
import org.lwjgl3.glfw.GLFWVidMode;
import org.lwjgl3.glfw.GLFWWindowFocusCallback;
import org.lwjgl3.glfw.GLFWWindowFocusCallbackI;
import org.lwjgl3.glfw.GLFWWindowIconifyCallback;
import org.lwjgl3.glfw.GLFWWindowIconifyCallbackI;
import org.lwjgl3.glfw.GLFWWindowPosCallback;
import org.lwjgl3.glfw.GLFWWindowPosCallbackI;
import org.lwjgl3.glfw.GLFWWindowRefreshCallback;
import org.lwjgl3.glfw.GLFWWindowRefreshCallbackI;
import org.lwjgl3.glfw.GLFWWindowSizeCallback;
import org.lwjgl3.glfw.GLFWWindowSizeCallbackI;
import org.lwjgl3.opengl.GL;
import org.lwjgl3.opengl.GL11;
import org.lwjgl3.system.Struct;

public class Display {
    private static String windowTitle = "Game";
    private static boolean displayCreated = false;
    private static boolean displayFocused = false;
    private static boolean displayVisible = true;
    private static boolean displayDirty = false;
    private static boolean displayResizable = false;
    private static boolean startFullscreen = false;
    private static DisplayMode mode = new DisplayMode(854, 480);
    private static DisplayMode desktopDisplayMode;
    private static int latestEventKey;
    private static int displayX;
    private static int displayY;
    private static boolean displayResized;
    private static int displayWidth;
    private static int displayHeight;
    private static int displayFramebufferWidth;
    private static int displayFramebufferHeight;
    private static boolean latestResized;
    private static int latestWidth;
    private static int latestHeight;
    private static ByteBuffer[] savedIcons;
    private static boolean cancelNextChar;
    private static KeyEvent ingredientKeyEvent;
    private static int[] savedX;
    private static int[] savedY;
    private static int[] savedW;
    private static int[] savedH;
    protected static DrawableGL drawable;

    public static void create(PixelFormat pixel_format, Drawable shared_drawable) {
        System.out.println("TODO: Implement Display.create(PixelFormat, Drawable)");
        Display.create();
    }

    public static void create(PixelFormat pixel_format, ContextAttribs attribs) {
        System.out.println("TODO: Implement Display.create(PixelFormat, ContextAttribs)");
        Display.create();
    }

    public static void create(PixelFormat pixel_format) {
        System.out.println("TODO: Implement Display.create(PixelFormat)");
        Display.create();
    }

    public static void create() {
        if (displayCreated) {
            return;
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)1);
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)139266, (int)2);
        GLFW.glfwWindowHint((int)139267, (int)1);
        GLFW.glfwWindowHint((int)131080, (int)(ForgeEarlyConfig.WINDOW_START_MAXIMIZED ? 1 : 0));
        GLFW.glfwWindowHint((int)131073, (int)(ForgeEarlyConfig.WINDOW_START_FOCUSED ? 1 : 0));
        displayFocused = ForgeEarlyConfig.WINDOW_START_FOCUSED;
        GLFW.glfwWindowHint((int)131074, (int)(ForgeEarlyConfig.WINDOW_START_ICONIFIED ? 1 : 0));
        displayVisible = !ForgeEarlyConfig.WINDOW_START_ICONIFIED;
        GLFW.glfwWindowHint((int)131077, (int)(ForgeEarlyConfig.WINDOW_DECORATED ? 1 : 0));
        displayX = (desktopDisplayMode.getWidth() - mode.getWidth()) / 2;
        displayY = (desktopDisplayMode.getHeight() - mode.getHeight()) / 2;
        GLFW.glfwWindowHint((int)131086, (int)displayX);
        GLFW.glfwWindowHint((int)131087, (int)displayY);
        GLFW.glfwWindowHint((int)135183, (int)desktopDisplayMode.getFrequency());
        GLFW.glfwWindowHint((int)135182, (int)(ForgeEarlyConfig.OPENGL_SRGB_CONTEXT ? 1 : 0));
        GLFW.glfwWindowHint((int)135184, (int)(ForgeEarlyConfig.OPENGL_DOUBLEBUFFER ? 1 : 0));
        GLFW.glfwWindowHint((int)139274, (int)(ForgeEarlyConfig.OPENGL_CONTEXT_NO_ERROR ? 1 : 0));
        GLFW.glfwWindowHint((int)139271, (int)(ForgeEarlyConfig.OPENGL_DEBUG_CONTEXT ? 1 : 0));
        GLFW.glfwWindowHint((int)139271, (int)(ForgeEarlyConfig.OPENGL_DEBUG_CONTEXT ? 1 : 0));
        GLFW.glfwWindowHintString((int)147457, (CharSequence)ForgeEarlyConfig.X11_CLASS_NAME);
        GLFW.glfwWindowHintString((int)143362, (CharSequence)ForgeEarlyConfig.COCOA_FRAME_NAME);
        GLFW.glfwWindowHint((int)143361, (int)0);
        Window.handle = GLFW.glfwCreateWindow((int)mode.getWidth(), (int)mode.getHeight(), (CharSequence)windowTitle, (long)0L, (long)0L);
        if (Window.handle == 0L) {
            throw new IllegalStateException("Failed to create Display window");
        }
        if (GLFW.glfwRawMouseMotionSupported() && ForgeEarlyConfig.RAW_INPUT) {
            GLFW.glfwSetInputMode((long)Window.handle, (int)208901, (int)1);
        }
        Window.keyCallback = new GLFWKeyCallback(){

            public void invoke(long window, int key, int scancode, int action, int mods) {
                cancelNextChar = false;
                if (key > 32 && key <= 96) {
                    if ((2 & mods) != 0) {
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, (char)(key & 0x1F));
                        cancelNextChar = true;
                    } else if (action > 0) {
                        ingredientKeyEvent = new KeyEvent(KeyCodes.toLwjglKey(key), '\u0000', action > 1 ? KeyState.REPEAT : KeyState.PRESS, Sys.getNanoTime());
                    } else {
                        Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, '\u0000');
                    }
                } else {
                    Keyboard.addGlfwKeyEvent(window, key, scancode, action, mods, '\u0000');
                }
            }
        };
        Window.charCallback = new GLFWCharCallback(){

            public void invoke(long window, int codepoint) {
                if (cancelNextChar) {
                    cancelNextChar = false;
                } else {
                    Keyboard.addCharEvent(0, (char)codepoint);
                }
            }
        };
        Window.charModsCallback = new GLFWCharModsCallback(){

            public void invoke(long window, int codepoint, int mods) {
                if (cancelNextChar) {
                    cancelNextChar = false;
                } else if (ingredientKeyEvent != null) {
                    Display.ingredientKeyEvent.aChar = (char)codepoint;
                    Keyboard.addKeyEvent(ingredientKeyEvent);
                    ingredientKeyEvent = null;
                    cancelNextChar = true;
                }
            }
        };
        Window.cursorPosCallback = new GLFWCursorPosCallback(){

            public void invoke(long window, double xpos, double ypos) {
                Mouse.addMoveEvent(xpos, ypos);
            }
        };
        Window.mouseButtonCallback = new GLFWMouseButtonCallback(){

            public void invoke(long window, int button, int action, int mods) {
                Mouse.addButtonEvent(button, action == 1);
            }
        };
        Window.scrollCallback = new GLFWScrollCallback(){

            public void invoke(long window, double xoffset, double yoffset) {
                Mouse.addWheelEvent(yoffset == 0.0 ? xoffset : yoffset);
            }
        };
        Window.windowFocusCallback = new GLFWWindowFocusCallback(){

            public void invoke(long window, boolean focused) {
                displayFocused = focused;
            }
        };
        Window.windowIconifyCallback = new GLFWWindowIconifyCallback(){

            public void invoke(long window, boolean iconified) {
                displayVisible = !iconified;
            }
        };
        Window.windowSizeCallback = new GLFWWindowSizeCallback(){

            public void invoke(long window, int width, int height) {
                latestResized = true;
                latestWidth = width;
                latestHeight = height;
            }
        };
        Window.windowPosCallback = new GLFWWindowPosCallback(){

            public void invoke(long window, int xpos, int ypos) {
                displayX = xpos;
                displayY = ypos;
            }
        };
        Window.windowRefreshCallback = new GLFWWindowRefreshCallback(){

            public void invoke(long window) {
                displayDirty = true;
            }
        };
        Window.framebufferSizeCallback = new GLFWFramebufferSizeCallback(){

            public void invoke(long window, int width, int height) {
                displayFramebufferWidth = width;
                displayFramebufferHeight = height;
            }
        };
        Window.setCallbacks();
        displayWidth = desktopDisplayMode.getWidth();
        displayHeight = desktopDisplayMode.getHeight();
        IntBuffer fbw = BufferUtils.createIntBuffer(1);
        IntBuffer fbh = BufferUtils.createIntBuffer(1);
        GLFW.glfwGetFramebufferSize((long)Window.handle, (IntBuffer)fbw, (IntBuffer)fbh);
        displayFramebufferWidth = fbw.get(0);
        displayFramebufferHeight = fbh.get(0);
        GLFW.glfwMakeContextCurrent((long)Window.handle);
        drawable = new DrawableGL();
        GL.createCapabilities();
        if (savedIcons != null) {
            Display.setIcon(savedIcons);
            savedIcons = null;
        }
        GLFW.glfwSwapInterval((int)1);
        displayCreated = true;
        if (startFullscreen) {
            Display.setFullscreen(true);
        }
        int[] x = new int[1];
        int[] y = new int[1];
        GLFW.glfwGetWindowSize((long)Window.handle, (int[])x, (int[])y);
        Window.windowSizeCallback.invoke(Window.handle, x[0], y[0]);
        GLFW.glfwGetFramebufferSize((long)Window.handle, (int[])x, (int[])y);
        Window.framebufferSizeCallback.invoke(Window.handle, x[0], y[0]);
    }

    public static boolean isCreated() {
        return displayCreated;
    }

    public static boolean isActive() {
        return displayFocused;
    }

    public static boolean isVisible() {
        return displayVisible;
    }

    public static void setLocation(int new_x, int new_y) {
        System.out.println("TODO: Implement Display.setLocation(int, int)");
    }

    public static void setVSyncEnabled(boolean sync) {
        GLFW.glfwSwapInterval((int)(sync ? 1 : 0));
    }

    public static long getWindow() {
        return Window.handle;
    }

    public static void update() {
        Display.update(true);
    }

    public static void update(boolean processMessages) {
        Display.swapBuffers();
        displayDirty = false;
        if (processMessages) {
            Display.processMessages();
        }
    }

    public static void processMessages() {
        GLFW.glfwPollEvents();
        Keyboard.poll();
        Mouse.poll();
        if (latestResized) {
            latestResized = false;
            displayResized = true;
            displayWidth = latestWidth;
            displayHeight = latestHeight;
        } else {
            displayResized = false;
        }
    }

    public static void swapBuffers() {
        GLFW.glfwSwapBuffers((long)Window.handle);
    }

    public static void destroy() {
        Window.releaseCallbacks();
        GLFW.glfwDestroyWindow((long)Window.handle);
        displayCreated = false;
    }

    public static void setDisplayMode(DisplayMode dm) {
        mode = dm;
    }

    public static DisplayMode getDisplayMode() {
        return mode;
    }

    public static DisplayMode[] getAvailableDisplayModes() {
        IntBuffer count = BufferUtils.createIntBuffer(1);
        GLFWVidMode.Buffer modes = GLFW.glfwGetVideoModes((long)GLFW.glfwGetPrimaryMonitor());
        DisplayMode[] displayModes = new DisplayMode[count.get(0)];
        for (int i2 = 0; i2 < count.get(0); ++i2) {
            modes.position(i2 * GLFWVidMode.SIZEOF);
            int w = modes.width();
            int h2 = modes.height();
            int b2 = modes.redBits() + modes.greenBits() + modes.blueBits();
            int r2 = modes.refreshRate();
            displayModes[i2] = new DisplayMode(w, h2, b2, r2);
        }
        return displayModes;
    }

    public static DisplayMode getDesktopDisplayMode() {
        return desktopDisplayMode;
    }

    public static boolean wasResized() {
        return displayResized;
    }

    public static int getX() {
        return displayX;
    }

    public static int getY() {
        return displayY;
    }

    public static int getWidth() {
        return displayWidth;
    }

    public static int getHeight() {
        return displayHeight;
    }

    public static int getFramebufferWidth() {
        return displayFramebufferWidth;
    }

    public static int getFramebufferHeight() {
        return displayFramebufferHeight;
    }

    public static String getTitle() {
        return windowTitle;
    }

    public static void setTitle(String title) {
        if (Display.getWindow() != 0L) {
            GLFW.glfwSetWindowTitle((long)Window.handle, (CharSequence)title);
        }
        windowTitle = title;
    }

    public static boolean isCloseRequested() {
        return GLFW.glfwWindowShouldClose((long)Window.handle);
    }

    public static boolean isDirty() {
        return displayDirty;
    }

    public static void setInitialBackground(float red, float green, float blue) {
    }

    public static int setIcon(ByteBuffer[] icons) {
        if (Display.getWindow() == 0L) {
            savedIcons = icons;
            return 0;
        }
        GLFWImage.Buffer glfwImages = GLFWImage.calloc((int)icons.length);
        ByteBuffer[] nativeBuffers = new ByteBuffer[icons.length];
        for (int icon = 0; icon < icons.length; ++icon) {
            nativeBuffers[icon] = org.lwjgl3.BufferUtils.createByteBuffer((int)icons[icon].capacity());
            nativeBuffers[icon].put(icons[icon]);
            nativeBuffers[icon].flip();
            int dimension = (int)Math.sqrt((double)nativeBuffers[icon].limit() / 4.0);
            if (dimension * dimension * 4 != nativeBuffers[icon].limit()) {
                throw new IllegalStateException();
            }
            glfwImages.put(icon, (Struct)GLFWImage.create().set(dimension, dimension, nativeBuffers[icon]));
        }
        GLFW.glfwSetWindowIcon((long)Display.getWindow(), (GLFWImage.Buffer)glfwImages);
        glfwImages.free();
        return 0;
    }

    public static void setResizable(boolean resizable) {
        displayResizable = resizable;
    }

    public static boolean isResizable() {
        return displayResizable;
    }

    public static void setDisplayModeAndFullscreen(DisplayMode mode) {
        System.out.println("TODO: Implement Display.setDisplayModeAndFullscreen(DisplayMode)");
    }

    public static void setFullscreen(boolean fullscreen) {
        long window = Display.getWindow();
        if (window == 0L) {
            startFullscreen = fullscreen;
            return;
        }
        boolean currentState = Display.isFullscreen();
        if (currentState == fullscreen) {
            return;
        }
        if (fullscreen) {
            GLFW.glfwGetWindowPos((long)window, (int[])savedX, (int[])savedY);
            GLFW.glfwGetWindowSize((long)window, (int[])savedW, (int[])savedH);
            long monitorId = GLFW.glfwGetPrimaryMonitor();
            GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)monitorId);
            GLFW.glfwSetWindowMonitor((long)window, (long)monitorId, (int)0, (int)0, (int)vidMode.width(), (int)vidMode.height(), (int)vidMode.refreshRate());
        } else {
            GLFW.glfwSetWindowMonitor((long)window, (long)0L, (int)savedX[0], (int)savedY[0], (int)savedW[0], (int)savedH[0], (int)0);
        }
    }

    public static boolean isFullscreen() {
        if (Display.getWindow() != 0L) {
            return GLFW.glfwGetWindowMonitor((long)Display.getWindow()) != 0L;
        }
        return false;
    }

    public static void setParent(Canvas parent) {
    }

    public static void releaseContext() {
        GLFW.glfwMakeContextCurrent((long)0L);
    }

    public static boolean isCurrent() {
        return true;
    }

    public static void makeCurrent() {
        GLFW.glfwMakeContextCurrent((long)Window.handle);
    }

    public static String getAdapter() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7936);
        }
        return "Unknown";
    }

    public static String getVersion() {
        if (Display.isCreated()) {
            return GL11.glGetString((int)7938);
        }
        return "Unknown";
    }

    public static void sync(int fps) {
        Sync.sync(fps);
    }

    public static Drawable getDrawable() {
        return drawable;
    }

    static DisplayImplementation getImplementation() {
        return null;
    }

    static {
        latestEventKey = 0;
        displayX = 0;
        displayY = 0;
        displayResized = false;
        displayWidth = 0;
        displayHeight = 0;
        displayFramebufferWidth = 0;
        displayFramebufferHeight = 0;
        latestResized = false;
        latestWidth = 0;
        latestHeight = 0;
        cancelNextChar = false;
        Sys.initialize();
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)monitor);
        int monitorWidth = vidmode.width();
        int monitorHeight = vidmode.height();
        int monitorBitPerPixel = vidmode.redBits() + vidmode.greenBits() + vidmode.blueBits();
        int monitorRefreshRate = vidmode.refreshRate();
        desktopDisplayMode = new DisplayMode(monitorWidth, monitorHeight, monitorBitPerPixel, monitorRefreshRate);
        savedX = new int[1];
        savedY = new int[1];
        savedW = new int[1];
        savedH = new int[1];
        drawable = null;
    }

    private static class Window {
        static long handle;
        static GLFWKeyCallback keyCallback;
        static GLFWCharCallback charCallback;
        static GLFWCharModsCallback charModsCallback;
        static GLFWCursorPosCallback cursorPosCallback;
        static GLFWMouseButtonCallback mouseButtonCallback;
        static GLFWScrollCallback scrollCallback;
        static GLFWWindowFocusCallback windowFocusCallback;
        static GLFWWindowIconifyCallback windowIconifyCallback;
        static GLFWWindowSizeCallback windowSizeCallback;
        static GLFWWindowPosCallback windowPosCallback;
        static GLFWWindowRefreshCallback windowRefreshCallback;
        static GLFWFramebufferSizeCallback framebufferSizeCallback;

        private Window() {
        }

        public static void setCallbacks() {
            GLFW.glfwSetKeyCallback((long)handle, (GLFWKeyCallbackI)keyCallback);
            GLFW.glfwSetCharCallback((long)handle, (GLFWCharCallbackI)charCallback);
            GLFW.glfwSetCharModsCallback((long)handle, (GLFWCharModsCallbackI)charModsCallback);
            GLFW.glfwSetCursorPosCallback((long)handle, (GLFWCursorPosCallbackI)cursorPosCallback);
            GLFW.glfwSetMouseButtonCallback((long)handle, (GLFWMouseButtonCallbackI)mouseButtonCallback);
            GLFW.glfwSetScrollCallback((long)handle, (GLFWScrollCallbackI)scrollCallback);
            GLFW.glfwSetWindowFocusCallback((long)handle, (GLFWWindowFocusCallbackI)windowFocusCallback);
            GLFW.glfwSetWindowIconifyCallback((long)handle, (GLFWWindowIconifyCallbackI)windowIconifyCallback);
            GLFW.glfwSetWindowSizeCallback((long)handle, (GLFWWindowSizeCallbackI)windowSizeCallback);
            GLFW.glfwSetWindowPosCallback((long)handle, (GLFWWindowPosCallbackI)windowPosCallback);
            GLFW.glfwSetWindowRefreshCallback((long)handle, (GLFWWindowRefreshCallbackI)windowRefreshCallback);
            GLFW.glfwSetFramebufferSizeCallback((long)handle, (GLFWFramebufferSizeCallbackI)framebufferSizeCallback);
        }

        public static void releaseCallbacks() {
            keyCallback.free();
            charCallback.free();
            cursorPosCallback.free();
            mouseButtonCallback.free();
            scrollCallback.free();
            windowFocusCallback.free();
            windowIconifyCallback.free();
            windowSizeCallback.free();
            windowPosCallback.free();
            windowRefreshCallback.free();
            framebufferSizeCallback.free();
        }
    }
}

