/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.awt.Desktop;
import java.awt.Toolkit;
import java.net.URI;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;
import org.lwjgl3.Version;
import org.lwjgl3.glfw.GLFW;
import org.lwjgl3.system.Configuration;
import org.lwjgl3.system.Platform;

public class Sys {
    public static void initialize() {
    }

    public static String getVersion() {
        return Version.getVersion();
    }

    public static long getTimerResolution() {
        return 1000L;
    }

    public static long getTime() {
        return (long)(GLFW.glfwGetTime() * 1000.0);
    }

    public static long getNanoTime() {
        return (long)(GLFW.glfwGetTime() * 1.0E9);
    }

    public static boolean openURL(String url) {
        if (!Desktop.isDesktopSupported()) {
            return false;
        }
        Desktop desktop = Desktop.getDesktop();
        if (!desktop.isSupported(Desktop.Action.BROWSE)) {
            return false;
        }
        try {
            desktop.browse(new URI(url));
            return true;
        }
        catch (Exception ex2) {
            return false;
        }
    }

    public static void alert(String title, String message) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e2) {
            LWJGLUtil.log("Caught exception while setting LAF: " + String.valueOf(e2));
        }
        JOptionPane.showMessageDialog(null, message, title, 2);
    }

    public static boolean is64Bit() {
        return Platform.getArchitecture().toString().endsWith("64");
    }

    public String getClipboard() {
        return GLFW.glfwGetClipboardString((long)Display.getWindow());
    }

    static {
        if (Platform.get() == Platform.MACOSX) {
            Configuration.GLFW_LIBRARY_NAME.set((Object)"glfw_async");
            Configuration.GLFW_CHECK_THREAD0.set((Object)false);
            Toolkit.getDefaultToolkit();
        }
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize glfw");
        }
    }
}

