/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher.mixinfix;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.relauncher.MixinBooterPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import sun.misc.Unsafe;

public class MixinFixer {
    static Unsafe unsafe;
    static boolean registered;
    static Set<String> queuedLateMixinConfigs;

    public static Set<String> retrieveLateMixinConfigs() {
        Set<String> ret = queuedLateMixinConfigs;
        queuedLateMixinConfigs = null;
        return ret;
    }

    public static void patchAncientModMixinsLoadingMethod() {
        if (registered) {
            return;
        }
        registered = true;
        ClassInfo.registerCallback(ci -> {
            if (!ci.isMixin() && "net/minecraftforge/fml/common/Loader".equals(ci.getName())) {
                try {
                    Field unsafe$theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                    unsafe$theUnsafe.setAccessible(true);
                    unsafe = (Unsafe)unsafe$theUnsafe.get(null);
                    Field classInfo$mixinsField = ClassInfo.class.getDeclaredField("mixins");
                    classInfo$mixinsField.setAccessible(true);
                    unsafe.putObject(ci, unsafe.objectFieldOffset(classInfo$mixinsField), new NotifiableMixinSet());
                }
                catch (ReflectiveOperationException e2) {
                    throw new RuntimeException("Unable to patch for compatibility with older mixin mods", e2);
                }
            }
        });
    }

    static {
        registered = false;
        queuedLateMixinConfigs = new ObjectOpenHashSet();
    }

    private static class NotifiableMixinSet
    extends HashSet<IMixinInfo> {
        private static Field mixinInfo$targetClassNames;
        static long mixinInfo$targetClassNames$offset;

        private NotifiableMixinSet() {
        }

        @Override
        public boolean add(IMixinInfo mixinInfo) {
            if (mixinInfo$targetClassNames == null) {
                try {
                    mixinInfo$targetClassNames = mixinInfo.getClass().getDeclaredField("targetClassNames");
                    mixinInfo$targetClassNames.setAccessible(true);
                    mixinInfo$targetClassNames$offset = unsafe.objectFieldOffset(mixinInfo$targetClassNames);
                }
                catch (NoSuchFieldException e2) {
                    throw new RuntimeException("Unable to patch for compatibility with older mixin mods", e2);
                }
            }
            switch (mixinInfo.getConfig().getName()) {
                case "mixins.integrated_proxy.loader.json": {
                    queuedLateMixinConfigs.add("mixins.integrated_proxy.mod.json");
                    unsafe.putObject(mixinInfo, mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    return true;
                }
                case "mixins.jeid.init.json": {
                    queuedLateMixinConfigs.add("mixins.jeid.modsupport.json");
                    queuedLateMixinConfigs.add("mixins.jeid.twilightforest.json");
                    unsafe.putObject(mixinInfo, mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    return true;
                }
                case "mixins.dj2addons.bootstrap.json": {
                    queuedLateMixinConfigs.add("mixins.dj2addons.def.api.json");
                    queuedLateMixinConfigs.add("mixins.dj2addons.def.custom.json");
                    queuedLateMixinConfigs.add("mixins.dj2addons.def.optimizations.json");
                    queuedLateMixinConfigs.add("mixins.dj2addons.def.patches.json");
                    queuedLateMixinConfigs.add("mixins.dj2addons.def.tweaks.json");
                    unsafe.putObject(mixinInfo, mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    this.correctingDj2Addons();
                    return true;
                }
                case "mixins.dj2addons.init.json": {
                    queuedLateMixinConfigs.add("mixins.dj2addons.json");
                    unsafe.putObject(mixinInfo, mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    this.correctingDj2Addons();
                    return true;
                }
                case "mixins.thaumicfixes.init.json": {
                    queuedLateMixinConfigs.add("mixins.thaumicfixes.modsupport.json");
                    unsafe.putObject(mixinInfo, mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                    return true;
                }
                case "mixins.loader.json": {
                    switch (mixinInfo.getConfig().getMixinPackage()) {
                        case "noobanidus.mods.erebusfix.mixins.": {
                            queuedLateMixinConfigs.add("mixins.erebusfix.json");
                            unsafe.putObject(mixinInfo, mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                            return true;
                        }
                        case "doomanidus.mods.uncraftingblacklist.mixins.": {
                            queuedLateMixinConfigs.add("mixins.uncraftingblacklist.json");
                            unsafe.putObject(mixinInfo, mixinInfo$targetClassNames$offset, new EmptyAbsorbingList());
                            return true;
                        }
                    }
                }
            }
            return super.add(mixinInfo);
        }

        private void correctingDj2Addons() {
            try {
                Class.forName("btpos.dj2addons.common.CoreInfo", true, (ClassLoader)Launch.classLoader).getMethod("onLoadCore", new Class[0]).invoke(null, new Object[0]);
            }
            catch (ReflectiveOperationException e1) {
                try {
                    Class.forName("org.btpos.dj2addons.core.DJ2AddonsCore", true, (ClassLoader)Launch.classLoader).getMethod("onLoadCore", new Class[0]).invoke(null, new Object[0]);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                }
                catch (ReflectiveOperationException e2) {
                    MixinBooterPlugin.LOGGER.fatal("DJ2Addons compatibility patch failed.", (Throwable)e2);
                }
            }
        }

        static {
            mixinInfo$targetClassNames$offset = 0L;
        }
    }

    private static class EmptyAbsorbingList
    extends AbstractList<String> {
        private EmptyAbsorbingList() {
        }

        @Override
        public boolean addAll(Collection<? extends String> c2) {
            return true;
        }

        @Override
        public String get(int index) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

