/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.discovery.json;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.discovery.asm.ModAnnotation;
import org.objectweb.asm.Type;

class ASMInfo {
    String name;
    String[] interfaces;
    List<Annotation> annotations;
    private Map<Integer, Annotation> byID;

    ASMInfo() {
    }

    public Annotation getSubAnnotation(int id) {
        if (this.byID == null) {
            this.byID = Maps.newHashMap();
            this.annotations.forEach(a2 -> {
                if (a2.id != null) {
                    this.byID.put(a2.id, (Annotation)a2);
                }
            });
        }
        return this.byID.get(id);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"").add("name", (Object)this.name).add("itf", (Object)this.interfaces).add("ann", this.annotations).toString();
    }

    static class Annotation {
        TargetType type;
        String name;
        String target;
        Integer id;
        ValueHolder value;
        Map<String, ValueHolder> values;
        private Map<String, Object> _values;

        Annotation() {
        }

        public Map<String, Object> getValues(ASMInfo pool) {
            if (this._values == null) {
                this._values = Maps.newHashMap();
                if (this.values != null) {
                    this.values.forEach((k, v) -> this._values.put((String)k, v.get(pool)));
                } else {
                    this._values.put("value", this.value == null ? null : this.value.get(pool));
                }
            }
            return this._values;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"").add("type", (Object)this.type).add("name", (Object)this.name).add("target", (Object)this.target).add("id", (Object)this.id).add("value", (Object)this.value).toString();
        }
    }

    static class ValueHolder {
        ValueType type;
        String value;
        String[] values;
        private Object _value;

        ValueHolder() {
        }

        private ValueType getType() {
            return this.type == null ? ValueType.STRING : this.type;
        }

        public Object get(ASMInfo pool) {
            if (this._value == null) {
                if (this.values != null) {
                    if (this.type == ValueType.ANNOTATION) {
                        ArrayList list = Lists.newArrayList();
                        this._value = list;
                        for (String s : this.values) {
                            Annotation sub = pool.getSubAnnotation(Integer.parseInt(s));
                            if (sub == null) {
                                FMLLog.log.error("Invalid Sub-Annotation in Annotation JSON: " + s);
                                continue;
                            }
                            list.add(sub.getValues(pool));
                        }
                    } else {
                        this._value = this.getType().array.apply(this.values);
                    }
                } else if (this.type == ValueType.ANNOTATION) {
                    Annotation sub = pool.getSubAnnotation(Integer.parseInt(this.value));
                    if (sub == null) {
                        FMLLog.log.error("Invalid Sub-Annotation in Annotation JSON: " + this.value);
                    } else {
                        this._value = sub.getValues(pool);
                    }
                } else {
                    this._value = this.getType().single.apply(this.value);
                }
            }
            return this._value;
        }
    }

    public static enum ValueType {
        BOOL(Boolean::valueOf, v -> {
            boolean[] ret = new boolean[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = Boolean.parseBoolean(v[x]);
            }
            return ret;
        }),
        BYTE(Byte::valueOf, v -> {
            byte[] ret = new byte[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = Byte.parseByte(v[x]);
            }
            return ret;
        }),
        CHAR(x -> Character.valueOf(x.charAt(0)), v -> {
            char[] ret = new char[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = v[x].charAt(0);
            }
            return ret;
        }),
        SHORT(Short::valueOf, v -> {
            short[] ret = new short[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = Short.parseShort(v[x]);
            }
            return ret;
        }),
        INT(Integer::valueOf, v -> {
            int[] ret = new int[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = Integer.parseInt(v[x]);
            }
            return ret;
        }),
        LONG(Long::valueOf, v -> {
            long[] ret = new long[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = Long.parseLong(v[x]);
            }
            return ret;
        }),
        FLOAT(Float::valueOf, v -> {
            float[] ret = new float[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = Float.parseFloat(v[x]);
            }
            return ret;
        }),
        DOUBLE(Double::valueOf, v -> {
            double[] ret = new double[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = Double.parseDouble(v[x]);
            }
            return ret;
        }),
        STRING(x -> x, x -> x),
        CLASS(Type::getType, v -> {
            Type[] ret = new Type[((String[])v).length];
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret[x] = Type.getType((String)v[x]);
            }
            return ret;
        }),
        ENUM(ValueType::getEnumHolder, v -> {
            ArrayList ret = Lists.newArrayList();
            for (int x = 0; x < ((String[])v).length; ++x) {
                ret.add(ValueType.getEnumHolder(v[x]));
            }
            return ret;
        }),
        ANNOTATION(null, null),
        NULL(x -> null, x -> null);

        public final Function<String, Object> single;
        public final Function<String[], Object> array;

        private ValueType(Function<String, Object> single, Function<String[], Object> array) {
            this.single = single;
            this.array = array;
        }

        private static ModAnnotation.EnumHolder getEnumHolder(String value) {
            int idx = value.lastIndexOf(47);
            if (idx <= 1) {
                throw new IllegalArgumentException("Can not create a EnumHolder for value: " + value);
            }
            String field = value.substring(idx + 1);
            value = value.substring(0, idx);
            idx = value.indexOf(59);
            value = value.substring(1, idx);
            return new ModAnnotation.EnumHolder(value, field);
        }
    }

    public static enum TargetType {
        CLASS,
        FIELD,
        METHOD,
        SUBTYPE;

    }
}

