/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers.deobf;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.ClassRemapper;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;

public class FMLRemappingAdapter
extends ClassRemapper {
    private static final List<Handle> META_FACTORIES = Arrays.asList(new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), new Handle(6, "java/lang/invoke/LambdaMetafactory", "altMetafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;", false));

    public FMLRemappingAdapter(ClassVisitor cv) {
        super(cv, (Remapper)FMLDeobfuscatingRemapper.INSTANCE);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (interfaces == null) {
            interfaces = new String[]{};
        }
        FMLDeobfuscatingRemapper.INSTANCE.mergeSuperMaps(name, superName, interfaces);
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FMLDeobfuscatingRemapper remapper = FMLDeobfuscatingRemapper.INSTANCE;
        FieldVisitor fv = this.cv.visitField(access, remapper.mapMemberFieldName(this.className, name, desc), remapper.mapDesc(desc), remapper.mapSignature(signature, true), remapper.mapValue(value));
        return this.createFieldRemapper(fv);
    }

    protected MethodVisitor createMethodRemapper(MethodVisitor mv) {
        return new StaticFixingMethodVisitor(mv, this.remapper);
    }

    private static class StaticFixingMethodVisitor
    extends MethodRemapper {
        public StaticFixingMethodVisitor(MethodVisitor mv, Remapper remapper) {
            super(mv, remapper);
        }

        public void visitFieldInsn(int opcode, String originalType, String originalName, String desc) {
            String replDesc;
            String type = this.remapper.mapType(originalType);
            String fieldName = this.remapper.mapFieldName(originalType, originalName, desc);
            String newDesc = this.remapper.mapDesc(desc);
            if (opcode == 178 && type.startsWith("net/minecraft/") && newDesc.startsWith("Lnet/minecraft/") && (replDesc = FMLDeobfuscatingRemapper.INSTANCE.getStaticFieldType(originalType, originalName, type, fieldName)) != null) {
                newDesc = this.remapper.mapDesc(replDesc);
            }
            if (this.mv != null) {
                this.mv.visitFieldInsn(opcode, type, fieldName, newDesc);
            }
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
            if (META_FACTORIES.contains(bsm)) {
                String owner = Type.getReturnType((String)desc).getInternalName();
                String odesc = ((Type)bsmArgs[0]).getDescriptor();
                name = this.remapper.mapMethodName(owner, name, odesc);
            }
            super.visitInvokeDynamicInsn(name, desc, bsm, bsmArgs);
        }
    }
}

