/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import com.cleanroommc.hackery.ReflectionHackery;
import com.cleanroommc.hackery.enums.EnumHackery;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraftforge.classloading.FMLForgePlugin;
import net.minecraftforge.fml.common.EnhancedRuntimeException;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.ArrayUtils;

public class EnumHelper {
    private static Class<?>[][] commonTypes = new Class[][]{{akc.class}, {agv.a.class, String.class, Integer.TYPE, int[].class, Integer.TYPE, qe.class, Float.TYPE}, {acd.a.class, String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, {vu.class}, {vr.class, Class.class, Integer.TYPE, bcz.class, Boolean.TYPE, Boolean.TYPE}, {bbt.p.a.class}, {all.class, Predicate.class}, {asw.a.class}, {bhc.a.class}, {ana.class, Integer.TYPE}, {aed.a.class}, {ain.a.class, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}, {aje.class, a.class, String.class}, {aar.class, String.class, Integer.TYPE}, {vq.a.class, BiPredicate.class}};

    @Nullable
    public static akc addAction(String name) {
        return EnumHackery.addEnumEntry(akc.class, name);
    }

    @Nullable
    public static agv.a addArmorMaterial(String name, String textureName, int durability, int[] reductionAmounts, int enchantability, qe soundOnEquip, float toughness) {
        return EnumHackery.addEnumEntry(agv.a.class, name, new Class[]{String.class, Integer.TYPE, int[].class, Integer.TYPE, qe.class, Float.TYPE}, new Object[]{textureName, durability, reductionAmounts, enchantability, soundOnEquip, Float.valueOf(toughness)});
    }

    @Nullable
    public static acd.a addArt(String name, String tile, int sizeX, int sizeY, int offsetX, int offsetY) {
        return EnumHackery.addEnumEntry(acd.a.class, name, new Class[]{String.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{tile, sizeX, sizeY, offsetX, offsetY});
    }

    @Nullable
    public static vu addCreatureAttribute(String name) {
        return EnumHackery.addEnumEntry(vu.class, name);
    }

    @Nullable
    public static vr addCreatureType(String name, Class<? extends vf> typeClass, int maxNumber, bcz material, boolean peaceful, boolean animal) {
        return EnumHackery.addEnumEntry(vr.class, name, new Class[]{Class.class, Integer.TYPE, bcz.class, Boolean.TYPE, Boolean.TYPE}, new Object[]{typeClass, maxNumber, material, peaceful, animal});
    }

    @Nullable
    public static bbt.p.a addDoor(String name) {
        return EnumHackery.addEnumEntry(bbt.p.a.class, name);
    }

    @Nullable
    public static all addEnchantmentType(String name, Predicate<ain> delegate) {
        return EnumHackery.addEnumEntry(all.class, name, new Class[]{Predicate.class}, new Object[]{delegate});
    }

    @Nullable
    public static asw.a addSensitivity(String name) {
        return EnumHackery.addEnumEntry(asw.a.class, name);
    }

    @Nullable
    public static bhc.a addMovingObjectType(String name) {
        return EnumHackery.addEnumEntry(bhc.a.class, name);
    }

    @Nullable
    public static ana addSkyBlock(String name, int lightValue) {
        return EnumHackery.addEnumEntry(ana.class, name, new Class[]{Integer.TYPE}, new Object[]{lightValue});
    }

    @Nullable
    public static aed.a addStatus(String name) {
        return EnumHackery.addEnumEntry(aed.a.class, name);
    }

    @Nullable
    public static ain.a addToolMaterial(String name, int harvestLevel, int maxUses, float efficiency, float damage, int enchantability) {
        return EnumHackery.addEnumEntry(ain.a.class, name, new Class[]{Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}, new Object[]{harvestLevel, maxUses, Float.valueOf(efficiency), Float.valueOf(damage), enchantability});
    }

    @Nullable
    @Deprecated
    public static aje addRarity(String name, a color, String displayName) {
        return EnumHackery.addEnumEntry(aje.class, name, new Class[]{a.class, String.class}, new Object[]{color, displayName});
    }

    @Nullable
    public static vq.a addSpawnPlacementType(String name, BiPredicate<amy, et> predicate) {
        return EnumHackery.addEnumEntry(vq.a.class, name, new Class[]{BiPredicate.class}, new Object[]{predicate});
    }

    @Nullable
    public static aar addHorseArmor(String name, String textureLocation, int armorStrength) {
        return EnumHackery.addEnumEntry(aar.class, name, new Class[]{String.class, Integer.TYPE}, new Object[]{textureLocation, armorStrength});
    }

    public static void setFailsafeFieldValue(Field field, @Nullable Object target, @Nullable Object value) throws Exception {
        if (Modifier.isStatic(field.getModifiers())) {
            ReflectionHackery.unsafe.putObject(ReflectionHackery.unsafe.staticFieldBase(field), ReflectionHackery.unsafe.staticFieldOffset(field), value);
        } else {
            ReflectionHackery.unsafe.putObject(target, ReflectionHackery.unsafe.objectFieldOffset(field), value);
        }
    }

    public static void testEnum(final Class<? extends Enum<?>> enumType, final Class<?>[] paramTypes) {
        Field[] fields;
        Field valuesField = null;
        for (Field field : fields = enumType.getDeclaredFields()) {
            String name = field.getName();
            if (!name.equals("$VALUES") && !name.equals("ENUM$VALUES")) continue;
            valuesField = field;
            break;
        }
        int flags = (FMLForgePlugin.RUNTIME_DEOBF ? 1 : 2) | 8 | 0x10 | 0x1000;
        if (valuesField == null) {
            String valueType = String.format("[L%s;", enumType.getName().replace('.', '/'));
            for (Field field : fields) {
                if ((field.getModifiers() & flags) != flags || !field.getType().getName().replace('.', '/').equals(valueType)) continue;
                valuesField = field;
                break;
            }
        }
        if (valuesField == null) {
            final ArrayList lines = Lists.newArrayList();
            lines.add(String.format("Could not find $VALUES field for enum: %s", enumType.getName()));
            lines.add(String.format("Runtime Deobf: %s", FMLForgePlugin.RUNTIME_DEOBF));
            lines.add(String.format("Flags: %s", String.format("%16s", Integer.toBinaryString(flags)).replace(' ', '0')));
            lines.add("Fields:");
            for (Field field : fields) {
                String mods = String.format("%16s", Integer.toBinaryString(field.getModifiers())).replace(' ', '0');
                lines.add(String.format("       %s %s: %s", mods, field.getName(), field.getType().getName()));
            }
            for (String line : lines) {
                FMLLog.log.fatal(line);
            }
            throw new EnhancedRuntimeException("Could not find $VALUES field for enum: " + enumType.getName()){

                @Override
                protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                    for (String line : lines) {
                        stream.println(line);
                    }
                }
            };
        }
        Constructor<? extends Enum<?>> ctr = null;
        Exception ex = null;
        try {
            Object[] prefixedParamTypes = new Class[]{String.class, Integer.TYPE};
            ctr = enumType.getDeclaredConstructor((Class[])ArrayUtils.addAll((Object[])prefixedParamTypes, (Object[])paramTypes));
        }
        catch (Exception e) {
            ex = e;
        }
        if (ctr == null || ex != null) {
            throw new EnhancedRuntimeException(String.format("Could not find constructor for Enum %s", enumType.getName()), (Throwable)ex){

                private String toString(Class<?>[] cls) {
                    StringBuilder b2 = new StringBuilder();
                    for (int x = 0; x < cls.length; ++x) {
                        b2.append(cls[x].getName());
                        if (x == cls.length - 1) continue;
                        b2.append(", ");
                    }
                    return b2.toString();
                }

                @Override
                protected void printStackTrace(EnhancedRuntimeException.WrappedPrintStream stream) {
                    stream.println("Target Arguments:");
                    stream.println("    java.lang.String, int, " + this.toString(paramTypes));
                    stream.println("Found Constructors:");
                    for (Constructor<?> ctr : enumType.getDeclaredConstructors()) {
                        stream.println("    " + this.toString(ctr.getParameterTypes()));
                    }
                }
            };
        }
    }

    @Nullable
    public static <T extends Enum<?>> T addEnum(Class<T> enumType, String enumName, Class<?>[] paramTypes, Object ... paramValues) {
        return EnumHackery.addEnumEntry(enumType, enumName, paramTypes, paramValues);
    }
}

