/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.ScreenshotEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.animation.Animation;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.SelectiveReloadStateHandler;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.ITransformation;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.async.ThreadNameCachingStrategy;
import org.apache.logging.log4j.core.impl.ReusableLogEventFactory;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ForgeHooksClient {
    static int renderPass = -1;
    static final ThreadLocal<amm> renderLayer = new ThreadLocal();
    private static int skyX;
    private static int skyZ;
    private static boolean skyInit;
    private static int skyRGBMultiplier;
    private static int updatescrollcounter;
    static int worldRenderPass;
    private static final Matrix4f flipX;
    private static final FloatBuffer matrixBuf;
    private static Map<Pair<ain, Integer>, Class<? extends avj>> tileItemMap;
    private static final LightGatheringTransformer lightGatherer;
    private static int slotMainHand;

    static cdr engine() {
        return FMLClientHandler.instance().getClient().Q;
    }

    public static String getArmorTexture(vg entity, aip armor, String _default, vl slot, String type) {
        String result = armor.c().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static void orientBedCamera(amy world, et pos, awt state, vg entity) {
        aow block = state.u();
        if (block != null && block.isBed(state, world, pos, entity)) {
            GL11.glRotatef(block.getBedDirection(state, world, pos).b() * 90, 0.0f, 1.0f, 0.0f);
        }
    }

    public static boolean onDrawBlockHighlight(buy context, aed player, bhc target, int subID, float partialTicks) {
        return MinecraftForge.EVENT_BUS.post(new DrawBlockHighlightEvent(context, player, target, subID, partialTicks));
    }

    public static void dispatchRenderLast(buy context, float partialTicks) {
        MinecraftForge.EVENT_BUS.post(new RenderWorldLastEvent(context, partialTicks));
    }

    public static boolean renderFirstPersonHand(buy context, float partialTicks, int renderPass) {
        return MinecraftForge.EVENT_BUS.post(new RenderHandEvent(context, partialTicks, renderPass));
    }

    public static boolean renderSpecificFirstPersonHand(ub hand, float partialTicks, float interpPitch, float swingProgress, float equipProgress, aip stack) {
        return MinecraftForge.EVENT_BUS.post(new RenderSpecificHandEvent(hand, partialTicks, interpPitch, swingProgress, equipProgress, stack));
    }

    public static void onTextureStitchedPre(cdp map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Pre(map));
        ModelLoader.White.INSTANCE.register(map);
        ModelDynBucket.LoaderDynBucket.INSTANCE.register(map);
    }

    public static void onTextureStitchedPost(cdp map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Post(map));
    }

    public static void onBlockColorsInit(bik blockColors) {
        MinecraftForge.EVENT_BUS.post(new ColorHandlerEvent.Block(blockColors));
    }

    public static void onItemColorsInit(bin itemColors, bik blockColors) {
        MinecraftForge.EVENT_BUS.post(new ColorHandlerEvent.Item(itemColors, blockColors));
    }

    public static void setRenderPass(int pass) {
        renderPass = pass;
    }

    public static void setRenderLayer(amm layer) {
        renderLayer.set(layer);
    }

    public static bpx getArmorModel(vp entityLiving, aip itemStack, vl slot, bpx _default) {
        bpx model = itemStack.c().getArmorModel(entityLiving, itemStack, slot, _default);
        return model == null ? _default : model;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ":" + base + name;
        }
        return base + name;
    }

    public static boolean postMouseEvent() {
        return MinecraftForge.EVENT_BUS.post(new MouseEvent());
    }

    public static float getOffsetFOV(aed entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post(fovUpdateEvent);
        return fovUpdateEvent.getNewfov();
    }

    public static float getFOVModifier(buq renderer, vg entity, awt state, double renderPartialTicks, float fov) {
        EntityViewRenderEvent.FOVModifier event = new EntityViewRenderEvent.FOVModifier(renderer, entity, state, renderPartialTicks, fov);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getFOV();
    }

    public static int getSkyBlendColour(amu world, et center) {
        if (center.p() == skyX && center.r() == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        bid settings = bib.z().t;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.k && ranges.length > 0) {
            distance = ranges[rk.a((int)settings.e, (int)0, (int)(ranges.length - 1))];
        }
        int r2 = 0;
        int g = 0;
        int b2 = 0;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                et pos = center.a(x, 0, z);
                anh biome = world.b(pos);
                int colour = biome.a(biome.a(pos));
                r2 += (colour & 0xFF0000) >> 16;
                g += (colour & 0xFF00) >> 8;
                b2 += colour & 0xFF;
                ++divider;
            }
        }
        int multiplier = (r2 / divider & 0xFF) << 16 | (g / divider & 0xFF) << 8 | b2 / divider & 0xFF;
        skyX = center.p();
        skyZ = center.r();
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }

    public static String renderMainMenu(blr gui, bip font, int width, int height, String splashText) {
        return splashText;
    }

    public static cgt playSound(chm manager, cgt sound) {
        PlaySoundEvent e = new PlaySoundEvent(manager, sound);
        MinecraftForge.EVENT_BUS.post(e);
        return e.getResultSound();
    }

    public static int getWorldRenderPass() {
        return worldRenderPass;
    }

    public static void drawScreen(blk screen, int mouseX, int mouseY, float partialTicks) {
        if (!MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Pre(screen, mouseX, mouseY, partialTicks))) {
            screen.a(mouseX, mouseY, partialTicks);
        }
        MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Post(screen, mouseX, mouseY, partialTicks));
    }

    public static float getFogDensity(buq renderer, vg entity, awt state, float partial, float density) {
        EntityViewRenderEvent.FogDensity event = new EntityViewRenderEvent.FogDensity(renderer, entity, state, partial, density);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return event.getDensity();
        }
        return -1.0f;
    }

    public static void onFogRender(buq renderer, vg entity, awt state, float partial, int mode, float distance) {
        MinecraftForge.EVENT_BUS.post(new EntityViewRenderEvent.RenderFogEvent(renderer, entity, state, partial, mode, distance));
    }

    public static void onModelBake(cgc modelManager, fm<cgd, cfy> modelRegistry, ModelLoader modelLoader) {
        MinecraftForge.EVENT_BUS.post(new ModelBakeEvent(modelManager, modelRegistry, modelLoader));
        modelLoader.onPostBakeEvent(modelRegistry);
    }

    public static cfy handleCameraTransforms(cfy model, bwc.b cameraTransformType, boolean leftHandHackery) {
        Pair pair = model.handlePerspective(cameraTransformType);
        if (pair.getRight() != null) {
            Matrix4f matrix = new Matrix4f((Matrix4f)pair.getRight());
            if (leftHandHackery) {
                matrix.mul(flipX, matrix);
                matrix.mul(matrix, flipX);
            }
            ForgeHooksClient.multiplyCurrentGlMatrix(matrix);
        }
        return (cfy)pair.getLeft();
    }

    public static void multiplyCurrentGlMatrix(Matrix4f matrix) {
        matrixBuf.clear();
        float[] t = new float[4];
        for (int i = 0; i < 4; ++i) {
            matrix.getColumn(i, t);
            matrixBuf.put(t);
        }
        matrixBuf.flip();
        GL11.glMultMatrix(matrixBuf);
    }

    public static void preDraw(ceb.b attrType, cea format, int element, int stride, ByteBuffer buffer) {
        ceb attr = format.c(element);
        int count = attr.c();
        int constant = attr.a().c();
        buffer.position(format.d(element));
        switch (attrType) {
            case a: {
                bus.b((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                bus.q((int)32884);
                break;
            }
            case b: {
                if (count != 3) {
                    throw new IllegalArgumentException("Normal attribute should have the size 3: " + String.valueOf(attr));
                }
                bus.a((int)constant, (int)stride, (ByteBuffer)buffer);
                bus.q((int)32885);
                break;
            }
            case c: {
                bus.c((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                bus.q((int)32886);
                break;
            }
            case d: {
                cii.l((int)(cii.q + attr.d()));
                bus.a((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                bus.q((int)32888);
                cii.l((int)cii.q);
                break;
            }
            case g: {
                break;
            }
            case GENERIC: {
                GL20.glEnableVertexAttribArray(attr.d());
                GL20.glVertexAttribPointer(attr.d(), count, constant, false, stride, buffer);
                break;
            }
            default: {
                FMLLog.log.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.a());
            }
        }
    }

    public static void postDraw(ceb.b attrType, cea format, int element, int stride, ByteBuffer buffer) {
        ceb attr = format.c(element);
        switch (attrType) {
            case a: {
                bus.p((int)32884);
                break;
            }
            case b: {
                bus.p((int)32885);
                break;
            }
            case c: {
                bus.p((int)32886);
                bus.I();
                break;
            }
            case d: {
                cii.l((int)(cii.q + attr.d()));
                bus.p((int)32888);
                cii.l((int)cii.q);
                break;
            }
            case g: {
                break;
            }
            case GENERIC: {
                GL20.glDisableVertexAttribArray(attr.d());
                break;
            }
            default: {
                FMLLog.log.fatal("Unimplemented vanilla attribute upload: {}", (Object)attrType.a());
            }
        }
    }

    public static void transform(org.lwjgl.util.vector.Vector3f vec, Matrix4f m) {
        Vector4f tmp = new Vector4f(vec.x, vec.y, vec.z, 1.0f);
        m.transform((Tuple4f)tmp);
        if ((double)Math.abs(tmp.w - 1.0f) > 1.0E-5) {
            tmp.scale(1.0f / tmp.w);
        }
        vec.set(tmp.x, tmp.y, tmp.z);
    }

    public static Matrix4f getMatrix(cfz modelRotation) {
        Matrix4f ret = new Matrix4f(TRSRTransformation.toVecmath(modelRotation.a()));
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.invert();
        ret.mul(tmp);
        return ret;
    }

    public static void putQuadColor(buk renderer, bvp quad, int color) {
        float cb = color & 0xFF;
        float cg = color >>> 8 & 0xFF;
        float cr = color >>> 16 & 0xFF;
        float ca = color >>> 24 & 0xFF;
        cea format = quad.getFormat();
        int size = format.f();
        int offset = format.e() / 4;
        boolean hasColor = format.d();
        for (int i = 0; i < 4; ++i) {
            int vc = hasColor ? quad.b()[offset + size * i] : -1;
            float vcr = vc & 0xFF;
            float vcg = vc >>> 8 & 0xFF;
            float vcb = vc >>> 16 & 0xFF;
            float vca = vc >>> 24 & 0xFF;
            int ncr = Math.min(255, (int)(cr * vcr / 255.0f));
            int ncg = Math.min(255, (int)(cg * vcg / 255.0f));
            int ncb = Math.min(255, (int)(cb * vcb / 255.0f));
            int nca = Math.min(255, (int)(ca * vca / 255.0f));
            renderer.putColorRGBA(renderer.c(4 - i), ncr, ncg, ncb, nca);
        }
    }

    public static void renderTileItem(ain item, int metadata) {
        bwy r2;
        Class<? extends avj> tileClass = tileItemMap.get(Pair.of((Object)item, (Object)metadata));
        if (tileClass != null && (r2 = bwx.a.a(tileClass)) != null) {
            r2.a(null, 0.0, 0.0, 0.0, 0.0f, -1, 0.0f);
        }
    }

    @Deprecated
    public static void registerTESRItemStack(ain item, int metadata, Class<? extends avj> TileClass) {
        tileItemMap.put((Pair<ain, Integer>)Pair.of((Object)item, (Object)metadata), TileClass);
    }

    public static void renderLitItem(bzw ri, cfy model, int color, aip stack) {
        ArrayList allquads = new ArrayList();
        for (fa enumfacing : fa.n) {
            allquads.addAll(model.a(null, enumfacing, 0L));
        }
        allquads.addAll(model.a(null, null, 0L));
        if (allquads.isEmpty()) {
            return;
        }
        ArrayList<bvp> segment = new ArrayList<bvp>();
        int segmentBlockLight = 0;
        int segmentSkyLight = 0;
        boolean segmentShading = true;
        boolean segmentLightingDirty = false;
        boolean segmentShadingDirty = false;
        boolean hasLighting = false;
        for (int i = 0; i < allquads.size(); ++i) {
            boolean shadeDirty;
            bvp q = (bvp)allquads.get(i);
            int bl = 0;
            int sl = 0;
            if (q.getFormat() != cdy.b && q.getFormat().a(1)) {
                q.pipe((IVertexConsumer)lightGatherer);
                if (lightGatherer.hasLighting()) {
                    bl = ForgeHooksClient.lightGatherer.blockLight;
                    sl = ForgeHooksClient.lightGatherer.skyLight;
                }
            }
            boolean shade = q.shouldApplyDiffuseLighting();
            boolean lightingDirty = segmentBlockLight != bl || segmentSkyLight != sl;
            boolean bl2 = shadeDirty = shade != segmentShading;
            if (lightingDirty || shadeDirty) {
                if (i > 0) {
                    ForgeHooksClient.drawSegment(ri, color, stack, segment, segmentBlockLight, segmentSkyLight, segmentShading, segmentLightingDirty && (hasLighting || segment.size() < i), segmentShadingDirty);
                }
                segmentBlockLight = bl;
                segmentSkyLight = sl;
                segmentShading = shade;
                segmentLightingDirty = lightingDirty;
                segmentShadingDirty = shadeDirty;
                hasLighting = segmentBlockLight > 0 || segmentSkyLight > 0 || !segmentShading;
            }
            segment.add(q);
        }
        ForgeHooksClient.drawSegment(ri, color, stack, segment, segmentBlockLight, segmentSkyLight, segmentShading, segmentLightingDirty && (hasLighting || segment.size() < allquads.size()), segmentShadingDirty);
        if (hasLighting) {
            cii.a((int)cii.r, (float)cii.lastBrightnessX, (float)cii.lastBrightnessY);
            bus.f();
        }
    }

    private static void drawSegment(bzw ri, int baseColor, aip stack, List<bvp> segment, int bl, int sl, boolean shade, boolean updateLighting, boolean updateShading) {
        buk bufferbuilder = bve.a().c();
        bufferbuilder.a(7, cdy.b);
        float lastBl = cii.lastBrightnessX;
        float lastSl = cii.lastBrightnessY;
        if (updateShading) {
            if (shade) {
                bus.f();
            } else {
                bus.g();
            }
        }
        if (updateLighting) {
            cii.a((int)cii.r, (float)Math.max((float)bl, lastBl), (float)Math.max((float)sl, lastSl));
        }
        ri.a(bufferbuilder, segment, baseColor, stack);
        bve.a().b();
        cii.lastBrightnessX = lastBl;
        cii.lastBrightnessY = lastSl;
        segment.clear();
    }

    public static void fillNormal(int[] faceData, fa facing) {
        Vector3f v1 = ForgeHooksClient.getVertexPos(faceData, 3);
        Vector3f t = ForgeHooksClient.getVertexPos(faceData, 1);
        Vector3f v2 = ForgeHooksClient.getVertexPos(faceData, 2);
        v1.sub((Tuple3f)t);
        t.set((Tuple3f)ForgeHooksClient.getVertexPos(faceData, 0));
        v2.sub((Tuple3f)t);
        v1.cross(v2, v1);
        v1.normalize();
        int x = (byte)Math.round(v1.x * 127.0f) & 0xFF;
        int y = (byte)Math.round(v1.y * 127.0f) & 0xFF;
        int z = (byte)Math.round(v1.z * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 7 + 6] = normal;
        }
    }

    private static Vector3f getVertexPos(int[] data, int vertex) {
        int idx = vertex * 7;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new Vector3f(x, y, z);
    }

    public static Optional<TRSRTransformation> applyTransform(bwb transform, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(TRSRTransformation.blockCenterToCorner(TRSRTransformation.from(transform)));
    }

    public static Optional<TRSRTransformation> applyTransform(cfz rotation, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(TRSRTransformation.from(rotation));
    }

    public static Optional<TRSRTransformation> applyTransform(Matrix4f matrix, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.empty();
        }
        return Optional.of(new TRSRTransformation(matrix));
    }

    public static void loadEntityShader(vg entity, buq entityRenderer) {
        nf shader;
        if (entity != null && (shader = ClientRegistry.getEntityShader(entity.getClass())) != null) {
            entityRenderer.a(shader);
        }
    }

    public static cfy getDamageModel(cfy ibakedmodel, cdq texture, awt state, amy world, et pos) {
        state = state.u().getExtendedState(state, world, pos);
        return new cgf.a(state, ibakedmodel, texture, pos).b();
    }

    public static boolean shouldCauseReequipAnimation(@Nonnull aip from, @Nonnull aip to, int slot) {
        boolean fromInvalid = from.b();
        boolean toInvalid = to.b();
        if (fromInvalid && toInvalid) {
            return false;
        }
        if (fromInvalid || toInvalid) {
            return true;
        }
        boolean changed = false;
        if (slot != -1) {
            changed = slot != slotMainHand;
            slotMainHand = slot;
        }
        return from.c().shouldCauseReequipAnimation(from, to, changed);
    }

    public static boolean shouldCauseBlockBreakReset(@Nonnull aip from, @Nonnull aip to) {
        return from.c().shouldCauseBlockBreakReset(from, to);
    }

    public static bvt applyUVLock(bvt blockFaceUV, fa originalSide, ITransformation rotation) {
        float t;
        TRSRTransformation global = new TRSRTransformation(rotation.getMatrix());
        Matrix4f uv = global.getUVLockTransform(originalSide).getMatrix();
        Vector4f vec = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        float u0 = blockFaceUV.a(blockFaceUV.c(0));
        float v0 = blockFaceUV.b(blockFaceUV.c(0));
        vec.x = u0 / 16.0f;
        vec.y = v0 / 16.0f;
        uv.transform((Tuple4f)vec);
        float uMin = 16.0f * vec.x;
        float vMin = 16.0f * vec.y;
        float u1 = blockFaceUV.a(blockFaceUV.c(2));
        float v1 = blockFaceUV.b(blockFaceUV.c(2));
        vec.x = u1 / 16.0f;
        vec.y = v1 / 16.0f;
        vec.z = 0.0f;
        vec.w = 1.0f;
        uv.transform((Tuple4f)vec);
        float uMax = 16.0f * vec.x;
        float vMax = 16.0f * vec.y;
        if (uMin > uMax && u0 < u1 || uMin < uMax && u0 > u1) {
            t = uMin;
            uMin = uMax;
            uMax = t;
        }
        if (vMin > vMax && v0 < v1 || vMin < vMax && v0 > v1) {
            t = vMin;
            vMin = vMax;
            vMax = t;
        }
        float a2 = (float)Math.toRadians(blockFaceUV.b);
        Vector3f rv = new Vector3f(rk.b((float)a2), rk.a((float)a2), 0.0f);
        Matrix3f rot = new Matrix3f();
        uv.getRotationScale(rot);
        rot.transform((Tuple3f)rv);
        int angle = rk.b((int)(-((int)Math.round(Math.toDegrees(Math.atan2(rv.y, rv.x)) / 90.0)) * 90), (int)360);
        return new bvt(new float[]{uMin, vMin, uMax, vMax}, angle);
    }

    public static RenderGameOverlayEvent.BossInfo bossBarRenderPre(bit res, bjj bossInfo, int x, int y, int increment) {
        RenderGameOverlayEvent.BossInfo evt = new RenderGameOverlayEvent.BossInfo(new RenderGameOverlayEvent(Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO, bossInfo, x, y, increment);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static void bossBarRenderPost(bit res) {
        MinecraftForge.EVENT_BUS.post(new RenderGameOverlayEvent.Post(new RenderGameOverlayEvent(Animation.getPartialTickTime(), res), RenderGameOverlayEvent.ElementType.BOSSINFO));
    }

    public static ScreenshotEvent onScreenshot(BufferedImage image, File screenshotFile) {
        ScreenshotEvent event = new ScreenshotEvent(image, screenshotFile);
        MinecraftForge.EVENT_BUS.post(event);
        return event;
    }

    public static Pair<? extends cfy, Matrix4f> handlePerspective(cfy model, bwc.b type) {
        TRSRTransformation tr2 = TRSRTransformation.from(model.e().b(type));
        Matrix4f mat = null;
        if (!tr2.isIdentity()) {
            mat = tr2.getMatrix();
        }
        return Pair.of((Object)model, (Object)mat);
    }

    public static void onInputUpdate(aed player, bub movementInput) {
        MinecraftForge.EVENT_BUS.post(new InputUpdateEvent(player, movementInput));
    }

    public static String getHorseArmorTexture(aaq horse, aip armorStack) {
        String texture = armorStack.c().getHorseArmorTexture((vq)horse, armorStack);
        if (texture == null) {
            texture = horse.dt().d();
        }
        return texture;
    }

    public static boolean shouldUseVanillaReloadableListener(ceq listener) {
        Predicate<IResourceType> predicate = SelectiveReloadStateHandler.INSTANCE.get();
        if (listener instanceof cgc || listener instanceof bzw) {
            return predicate.test(VanillaResourceType.MODELS);
        }
        if (listener instanceof bvm || listener instanceof buy) {
            return predicate.test(VanillaResourceType.MODELS);
        }
        if (listener instanceof cdr || listener instanceof bip) {
            return predicate.test(VanillaResourceType.TEXTURES);
        }
        if (listener instanceof cel || listener instanceof cem) {
            return predicate.test(VanillaResourceType.TEXTURES);
        }
        if (listener instanceof cho) {
            return predicate.test(VanillaResourceType.SOUNDS);
        }
        if (listener instanceof buq) {
            return predicate.test(VanillaResourceType.SHADERS);
        }
        if (listener instanceof cfa || listener instanceof cgx) {
            return predicate.test(VanillaResourceType.LANGUAGES);
        }
        return true;
    }

    public static void invalidateLog4jThreadCache() {
        try {
            Field nameField = ThreadNameCachingStrategy.class.getDeclaredField("THREADLOCAL_NAME");
            Field logEventField = ReusableLogEventFactory.class.getDeclaredField("mutableLogEventThreadLocal");
            nameField.setAccessible(true);
            logEventField.setAccessible(true);
            ((ThreadLocal)nameField.get(null)).set(null);
            ((ThreadLocal)logEventField.get(null)).set(null);
        }
        catch (NoClassDefFoundError | ReflectiveOperationException e) {
            FMLLog.log.error("Unable to invalidate log4j thread cache, thread fields in logs may be inaccurate", e);
        }
    }

    static {
        updatescrollcounter = 0;
        flipX = new Matrix4f();
        flipX.setIdentity();
        ForgeHooksClient.flipX.m00 = -1.0f;
        matrixBuf = BufferUtils.createFloatBuffer(16);
        tileItemMap = Maps.newHashMap();
        lightGatherer = new LightGatheringTransformer();
        slotMainHand = 0;
    }

    private static class LightGatheringTransformer
    extends QuadGatheringTransformer {
        private static final cea FORMAT = new cea().a(cdy.o).a(cdy.p);
        int blockLight;
        int skyLight;

        private LightGatheringTransformer() {
            this.setVertexFormat(FORMAT);
        }

        boolean hasLighting() {
            return this.dataLength[1] >= 2;
        }

        @Override
        protected void processQuad() {
            this.blockLight = 0;
            this.skyLight = 0;
            for (int i = 0; i < 4; ++i) {
                this.blockLight += (int)(this.quadData[1][i][0] * 65535.0f / 32.0f);
                this.skyLight += (int)(this.quadData[1][i][1] * 65535.0f / 32.0f);
            }
            this.blockLight *= 4;
            this.skyLight *= 4;
        }

        @Override
        public void setQuadTint(int tint) {
        }

        @Override
        public void setQuadOrientation(fa orientation) {
        }

        @Override
        public void setApplyDiffuseLighting(boolean diffuse) {
        }

        @Override
        public void setTexture(cdq texture) {
        }
    }
}

