/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.util;

import java.util.ArrayList;
import java.util.List;
import jetpacks.config.ModConfig;
import jetpacks.item.JetpackItem;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TextUtils {
    private static final Component on = TextUtils.translate("misc", "enabled", ChatFormatting.GREEN, new Object[0]);
    private static final Component off = TextUtils.translate("misc", "disabled", ChatFormatting.RED, new Object[0]);
    private static final Component notAvailable = TextUtils.translate("misc", "notAvailable", ChatFormatting.DARK_GRAY, new Object[0]);
    private static final String ENERGY_FORMAT = "%,d";

    public static Component translate(String prefix, String suffix, ChatFormatting style, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "tjetpacks", suffix);
        return Component.m_237110_((String)key, (Object[])params).m_130940_(style);
    }

    public static Component translate(String prefix, String suffix, Object ... params) {
        String key = String.format("%s.%s.%s", prefix, "tjetpacks", suffix);
        return Component.m_237110_((String)key, (Object[])params);
    }

    public static Component energy(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return TextUtils.translate("misc", "energy", s1);
    }

    public static Component energyPerTick(int amount) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        return TextUtils.translate("misc", "energyPerTick", ChatFormatting.WHITE, new Object[]{s1});
    }

    public static Component energyWithMax(int amount, int max) {
        String s1 = String.format(ENERGY_FORMAT, amount);
        String s2 = String.format(ENERGY_FORMAT, max);
        return TextUtils.translate("misc", "energyWithMax", s1, s2);
    }

    public static Component fluidWithMax(IFluidHandler fluidHandler, int tank) {
        FluidStack stack = fluidHandler.getFluidInTank(tank);
        return TextUtils.fluidWithMax(stack, fluidHandler.getTankCapacity(tank));
    }

    public static Component fluidWithMax(FluidStack stack, int tankCapacity) {
        Component fluidName = stack.getDisplayName();
        String s1 = String.format(ENERGY_FORMAT, stack.getAmount());
        String s2 = String.format(ENERGY_FORMAT, tankCapacity);
        return TextUtils.translate("misc", "fluidWithMax", fluidName, s1, s2);
    }

    public static Component getShiftText() {
        return TextUtils.translate("tooltip", "showDetails", Component.m_237113_((String)"Shift").m_130940_(ChatFormatting.GOLD));
    }

    public static void addBaseInfo(ItemStack stack, List<Component> list) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        list.add(TextUtils.translate("tooltip", "tier", jetpack.tier));
        if (jetpack.isCreative) {
            list.add(TextUtils.translate("tooltip", "infiniteEnergy", ChatFormatting.LIGHT_PURPLE, new Object[0]));
        } else {
            list.add(TextUtils.energyWithMax(jetpack.getEnergy(stack), jetpack.getCapacity(stack)));
        }
    }

    public static void addShiftInfo(ItemStack stack, List<Component> list) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        list.add(TextUtils.translate("tooltip", "itemJetpack.engine", ChatFormatting.GOLD, new Object[]{jetpack.isEngineOn(stack) ? on : off}));
        list.add(TextUtils.translate("tooltip", "itemJetpack.hover", ChatFormatting.GOLD, new Object[]{jetpack.isHoverOn(stack) ? on : off}));
        if (jetpack.getJetpackType().getChargerMode()) {
            list.add(TextUtils.translate("tooltip", "itemJetpack.charger", ChatFormatting.GOLD, new Object[]{jetpack.isChargerOn(stack) ? on : off}));
        }
        if (!jetpack.isCreative) {
            list.add(TextUtils.translate("tooltip", "itemJetpack.energyUsage", ChatFormatting.GOLD, new Object[]{TextUtils.energyPerTick(jetpack.getEnergyUsage(stack))}));
        }
        Component particle = TextUtils.translate("tooltip", "particle." + JetpackItem.getParticleId(stack), ChatFormatting.WHITE, new Object[0]);
        list.add(TextUtils.translate("tooltip", "itemJetpack.particleType", ChatFormatting.GOLD, new Object[]{particle}));
        MutableComponent throttle = Component.m_237113_((String)(jetpack.getThrottle(stack) + "%")).m_130940_(ChatFormatting.WHITE);
        list.add(TextUtils.translate("tooltip", "itemJetpack.throttle", ChatFormatting.GOLD, new Object[]{throttle}));
    }

    public static void addHUDInfoText(ItemStack stack, List<Component> list) {
        if (ModConfig.client_showThrottle) {
            JetpackItem jetpack = (JetpackItem)stack.m_41720_();
            list.add(TextUtils.translate("hud", "throttle", jetpack.getThrottle(stack)));
        }
        list.add(TextUtils.getEnergyText(stack));
        list.add(TextUtils.getHUDStates(stack));
    }

    public static Component getEnergyText(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        if (jetpack.isCreative) {
            return TextUtils.translate("hud", "energyDisplay", TextUtils.translate("hud", "infiniteEnergy", ChatFormatting.LIGHT_PURPLE, new Object[0]));
        }
        int percent = (int)Math.ceil((double)jetpack.getEnergy(stack) / (double)jetpack.getCapacity(stack) * 100.0);
        Component percentageText = TextUtils.getColoredPercent(percent);
        Component exactText = TextUtils.energy(jetpack.getEnergy(stack));
        if (ModConfig.client_showExactEnergy) {
            return TextUtils.translate("hud", "energyDisplayExtra", percentageText, exactText);
        }
        return TextUtils.translate("hud", "energyDisplay", percentageText);
    }

    public static Component getColoredPercent(int percent) {
        if (percent > 70) {
            return Component.m_237113_((String)String.format("%s%%", percent)).m_130940_(ChatFormatting.GREEN);
        }
        if (percent > 40) {
            return Component.m_237113_((String)String.format("%s%%", percent)).m_130940_(ChatFormatting.YELLOW);
        }
        if (percent > 10) {
            return Component.m_237113_((String)String.format("%s%%", percent)).m_130940_(ChatFormatting.GOLD);
        }
        if (percent > 0) {
            return Component.m_237113_((String)String.format("%s%%", percent)).m_130940_(ChatFormatting.RED);
        }
        return TextUtils.translate("hud", "energyDepleted", ChatFormatting.RED, new Object[0]);
    }

    public static Component getHUDStates(ItemStack stack) {
        JetpackItem jetpack = (JetpackItem)stack.m_41720_();
        ArrayList<Component> statesTexts = new ArrayList<Component>();
        int stateCount = 1;
        ChatFormatting on = ChatFormatting.GREEN;
        ChatFormatting off = ChatFormatting.RED;
        ChatFormatting notAvailable = ChatFormatting.DARK_GRAY;
        Component engineState = TextUtils.translate("hud", "engine", jetpack.isEngineOn(stack) ? on : off, new Object[0]);
        Component hoverState = TextUtils.translate("hud", "hover", jetpack.isHoverOn(stack) ? on : off, new Object[0]);
        Component eHoverState = TextUtils.translate("hud", "eHover", jetpack.getJetpackType().getEmergencyHoverMode() ? (jetpack.isEHoverOn(stack) ? on : off) : notAvailable, new Object[0]);
        Component chargerState = TextUtils.translate("hud", "charger", jetpack.getJetpackType().getChargerMode() ? (jetpack.isChargerOn(stack) ? on : off) : notAvailable, new Object[0]);
        statesTexts.add(engineState);
        if (ModConfig.client_showHoverState && jetpack.getJetpackType().getHoverMode()) {
            statesTexts.add(hoverState);
            ++stateCount;
        }
        if (ModConfig.client_showEHoverState && jetpack.getJetpackType().getEmergencyHoverMode()) {
            statesTexts.add(eHoverState);
            ++stateCount;
        }
        if (ModConfig.client_showChargerState && jetpack.getJetpackType().getChargerMode()) {
            statesTexts.add(chargerState);
            ++stateCount;
        }
        return TextUtils.translate("hud", "jetpackStates." + stateCount, statesTexts.toArray());
    }

    public static Component getStateToggle(String state, boolean value) {
        return TextUtils.translate("chat", "itemJetpack." + state, value ? on : off);
    }

    public static Component getEmergencyText() {
        return TextUtils.translate("chat", "itemJetpack.emergencyHoverModeActivated", ChatFormatting.RED, new Object[0]);
    }
}

