/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.network.packets;

import java.util.function.Supplier;
import jetpacks.client.ui.JetpackScreen;
import jetpacks.item.JetpackItem;
import jetpacks.network.NetworkHandler;
import jetpacks.util.JetpackUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketUpdateClientJetpackUI {
    final boolean engineOn;
    final boolean hoverOn;
    final boolean eHoverOn;
    final boolean chargerOn;

    public PacketUpdateClientJetpackUI(FriendlyByteBuf buf) {
        this.engineOn = buf.readBoolean();
        this.hoverOn = buf.readBoolean();
        this.eHoverOn = buf.readBoolean();
        this.chargerOn = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.engineOn);
        buf.writeBoolean(this.hoverOn);
        buf.writeBoolean(this.eHoverOn);
        buf.writeBoolean(this.chargerOn);
    }

    public PacketUpdateClientJetpackUI(JetpackItem jetpack, ItemStack stack) {
        this.engineOn = jetpack.isEngineOn(stack);
        this.hoverOn = jetpack.isHoverOn(stack);
        this.eHoverOn = jetpack.isEHoverOn(stack);
        this.chargerOn = jetpack.isChargerOn(stack);
    }

    public static PacketUpdateClientJetpackUI fromBytes(FriendlyByteBuf buffer) {
        return new PacketUpdateClientJetpackUI(buffer);
    }

    public PacketUpdateClientJetpackUI() {
        this.engineOn = false;
        this.hoverOn = false;
        this.eHoverOn = false;
        this.chargerOn = false;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                System.out.println("PacketJetpackStatus: " + this.engineOn + ", " + this.hoverOn + ", " + this.eHoverOn + ", " + this.chargerOn);
                JetpackScreen.update(this.engineOn, this.hoverOn, this.eHoverOn, this.chargerOn);
            } else if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_SERVER) {
                ItemStack stack;
                Item item;
                System.out.println("PacketJetpackStatus: Requesting status");
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null && (item = (stack = JetpackUtil.getItemFromChest((Player)player)).m_41720_()) instanceof JetpackItem) {
                    JetpackItem jetpack = (JetpackItem)item;
                    NetworkHandler.sendToClient(new PacketUpdateClientJetpackUI(jetpack, stack), player);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

