/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.network.packets;

import java.util.function.Supplier;
import jetpacks.item.JetpackItem;
import jetpacks.network.NetworkHandler;
import jetpacks.network.packets.PacketUpdateClientJetpackUI;
import jetpacks.network.packets.ToggleStatus;
import jetpacks.util.JetpackUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketSetEngine {
    final ToggleStatus status;

    public PacketSetEngine(FriendlyByteBuf buf) {
        this.status = (ToggleStatus)buf.m_130066_(ToggleStatus.class);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.status);
    }

    public PacketSetEngine(ToggleStatus status) {
        this.status = status;
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ItemStack stack;
            Item item;
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null && (item = (stack = JetpackUtil.getItemFromChest((Player)player)).m_41720_()) instanceof JetpackItem) {
                JetpackItem jetpack = (JetpackItem)item;
                if (this.status == ToggleStatus.TOGGLE) {
                    jetpack.setEngineOn(stack, (Player)player, !jetpack.isEngineOn(stack));
                } else if (this.status == ToggleStatus.ON) {
                    jetpack.setEngineOn(stack, (Player)player, true);
                }
                NetworkHandler.sendToClient(new PacketUpdateClientJetpackUI(jetpack, stack), player);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

