/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.network.packets;

import java.util.Optional;
import java.util.function.Supplier;
import jetpacks.ThermalJetpacks;
import jetpacks.item.JetpackType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class PacketJetpackConfigSync {
    private final String configKey;
    private final int energyCapacity;
    private final int energyUsage;
    private final int energyPerTickIn;
    private final int energyPerTickOut;
    private final int armorReduction;
    private final int armorEnergyPerHit;
    private final int enchantability;
    private final double speedVertical;
    private final double accelVertical;
    private final double speedVerticalHover;
    private final double speedVerticalHoverSlow;
    private final double speedSideways;
    private final double sprintSpeedModifier;
    private final double sprintEnergyModifier;
    private final boolean hoverMode;
    private final boolean emergencyHoverMode;
    private final boolean chargerMode;

    public PacketJetpackConfigSync(JetpackType jetpack) {
        this.configKey = jetpack.getConfigKey();
        this.energyCapacity = jetpack.getEnergyCapacity();
        this.energyUsage = jetpack.getEnergyUsage();
        this.energyPerTickIn = jetpack.getEnergyPerTickIn();
        this.energyPerTickOut = jetpack.getEnergyPerTickOut();
        this.armorReduction = jetpack.getArmorReduction();
        this.armorEnergyPerHit = jetpack.getArmorEnergyPerHit();
        this.enchantability = jetpack.getEnchantability();
        this.speedVertical = jetpack.getSpeedVertical();
        this.accelVertical = jetpack.getAccelVertical();
        this.speedVerticalHover = jetpack.getSpeedVerticalHover();
        this.speedVerticalHoverSlow = jetpack.getSpeedVerticalHoverSlow();
        this.speedSideways = jetpack.getSpeedSideways();
        this.sprintSpeedModifier = jetpack.getSprintSpeedModifier();
        this.sprintEnergyModifier = jetpack.getSprintEnergyModifier();
        this.hoverMode = jetpack.getHoverMode();
        this.emergencyHoverMode = jetpack.getEmergencyHoverMode();
        this.chargerMode = jetpack.getChargerMode();
    }

    public PacketJetpackConfigSync(FriendlyByteBuf buf) {
        this.configKey = buf.m_130277_();
        this.energyCapacity = buf.readInt();
        this.energyUsage = buf.readInt();
        this.energyPerTickIn = buf.readInt();
        this.energyPerTickOut = buf.readInt();
        this.armorReduction = buf.readInt();
        this.armorEnergyPerHit = buf.readInt();
        this.enchantability = buf.readInt();
        this.speedVertical = buf.readDouble();
        this.accelVertical = buf.readDouble();
        this.speedVerticalHover = buf.readDouble();
        this.speedVerticalHoverSlow = buf.readDouble();
        this.speedSideways = buf.readDouble();
        this.sprintSpeedModifier = buf.readDouble();
        this.sprintEnergyModifier = buf.readDouble();
        this.hoverMode = buf.readBoolean();
        this.emergencyHoverMode = buf.readBoolean();
        this.chargerMode = buf.readBoolean();
    }

    public static PacketJetpackConfigSync fromBytes(FriendlyByteBuf buffer) {
        return new PacketJetpackConfigSync(buffer);
    }

    public static void toBytes(PacketJetpackConfigSync packet, FriendlyByteBuf buffer) {
        buffer.m_130070_(packet.configKey);
        buffer.writeInt(packet.energyCapacity);
        buffer.writeInt(packet.energyUsage);
        buffer.writeInt(packet.energyPerTickIn);
        buffer.writeInt(packet.energyPerTickOut);
        buffer.writeInt(packet.armorReduction);
        buffer.writeInt(packet.armorEnergyPerHit);
        buffer.writeInt(packet.enchantability);
        buffer.writeDouble(packet.speedVertical);
        buffer.writeDouble(packet.accelVertical);
        buffer.writeDouble(packet.speedVerticalHover);
        buffer.writeDouble(packet.speedVerticalHoverSlow);
        buffer.writeDouble(packet.speedSideways);
        buffer.writeDouble(packet.sprintSpeedModifier);
        buffer.writeDouble(packet.sprintEnergyModifier);
        buffer.writeBoolean(packet.hoverMode);
        buffer.writeBoolean(packet.emergencyHoverMode);
        buffer.writeBoolean(packet.chargerMode);
    }

    public static void handle(PacketJetpackConfigSync message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
                Optional<JetpackType> jetpackTypeOptional = JetpackType.JETPACK_ALL.stream().filter(jetpack -> jetpack.getConfigKey().equals(message.configKey)).findFirst();
                if (jetpackTypeOptional.isPresent()) {
                    JetpackType jetpack2 = jetpackTypeOptional.get();
                    jetpack2.setEnergyCapacity(message.energyCapacity);
                    jetpack2.setEnergyUsage(message.energyUsage);
                    jetpack2.setEnergyPerTickIn(message.energyPerTickIn);
                    jetpack2.setEnergyPerTickOut(message.energyPerTickOut);
                    jetpack2.setArmorReduction(message.armorReduction);
                    jetpack2.setArmorEnergyPerHit(message.armorEnergyPerHit);
                    jetpack2.setEnchantability(message.enchantability);
                    jetpack2.setSpeedVertical(message.speedVertical);
                    jetpack2.setAccelVertical(message.accelVertical);
                    jetpack2.setSpeedVerticalHover(message.speedVerticalHover);
                    jetpack2.setSpeedVerticalHoverSlow(message.speedVerticalHoverSlow);
                    jetpack2.setSpeedSideways(message.speedSideways);
                    jetpack2.setSprintSpeedModifier(message.sprintSpeedModifier);
                    jetpack2.setSprintEnergyModifier(message.sprintEnergyModifier);
                    jetpack2.setHoverMode(message.hoverMode);
                    jetpack2.setEmergencyHoverMode(message.emergencyHoverMode);
                    jetpack2.setChargerMode(message.chargerMode);
                } else {
                    ThermalJetpacks.LOGGER.error("Attempted to update config for unknown config key {}. Please make sure you have to correct version of the mod.", (Object)message.configKey);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

