/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.network.packets;

import java.util.function.Supplier;
import jetpacks.client.ui.HUDHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class PacketEnableJetpackHUD {
    final boolean enabled;

    public PacketEnableJetpackHUD(FriendlyByteBuf buf) {
        this.enabled = buf.readBoolean();
    }

    public PacketEnableJetpackHUD(boolean enabled) {
        this.enabled = enabled;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.enabled);
    }

    public static PacketEnableJetpackHUD fromBytes(FriendlyByteBuf buffer) {
        return new PacketEnableJetpackHUD(buffer);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            System.out.println("Toggling HUD: " + this.enabled);
            HUDHandler.renderJetpackHUD = this.enabled;
        });
        ctx.get().setPacketHandled(true);
    }
}

