/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jetpacks.I_ServerGamePacketListenerImpl;
import jetpacks.RegistryHandler;
import jetpacks.client.JetpackModelLayers;
import jetpacks.client.ui.IHUDInfoProvider;
import jetpacks.energy.EnergyStorageImpl;
import jetpacks.energy.IEnergyContainer;
import jetpacks.handlers.CommonJetpackHandler;
import jetpacks.item.JetpackArmorMaterial;
import jetpacks.item.JetpackType;
import jetpacks.util.JetpackUtil;
import jetpacks.util.KeyboardUtil;
import jetpacks.util.NBTUtil;
import jetpacks.util.TextUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class JetpackItem
extends ArmorItem
implements IHUDInfoProvider,
IEnergyContainer {
    private final JetpackType jetpackType;
    public final int tier;
    public final boolean isCreative;
    boolean inSlot = false;
    final float HOVER_FALL = 0.15f;
    boolean hoverMode;
    double hoverSpeed;
    boolean flyKeyDown;
    boolean descendKeyDown;
    double currentAccel;
    double currentSpeedVertical;
    double speedVerticalHover;
    double speedVerticalHoverSlow;

    public JetpackItem(JetpackType jetpackType, boolean isCreative) {
        super((ArmorMaterial)(jetpackType.isArmored() ? JetpackArmorMaterial.JETPACK_ARMORED : JetpackArmorMaterial.JETPACK), ArmorItem.Type.CHESTPLATE, new Item.Properties().setNoRepair());
        this.isCreative = isCreative;
        this.jetpackType = jetpackType;
        this.tier = jetpackType.getTier();
    }

    public JetpackItem(JetpackType jetpackType, JetpackArmorMaterial material, boolean isCreative) {
        super((ArmorMaterial)material, ArmorItem.Type.CHESTPLATE, new Item.Properties());
        this.isCreative = isCreative;
        this.jetpackType = jetpackType;
        this.tier = jetpackType.getTier();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(Rendering.INSTANCE);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return this.jetpackType.getArmorTexture();
    }

    public void m_6883_(ItemStack stack, Level level, Entity holder, int vanillaIndex, boolean selected) {
        Player player;
        if (holder instanceof Player && !(player = (Player)holder).m_5833_() && !player.m_150110_().f_35935_) {
            if (level.m_46467_() % 20L != 0L) {
                this.inSlot = JetpackUtil.checkTickForEquippedSlot(vanillaIndex, stack, player);
            }
            if (!this.inSlot) {
                return;
            }
            this.flyUser(player, stack, this, false);
            if (this.jetpackType.getChargerMode() && this.isChargerOn(stack)) {
                this.chargeInventory(player, stack);
            }
        }
        super.m_6883_(stack, level, holder, vanillaIndex, selected);
    }

    public JetpackType getJetpackType() {
        return this.jetpackType;
    }

    public int m_6473_() {
        return super.m_6473_() + this.jetpackType.getEnchantability();
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || this.isCreative;
    }

    public Rarity m_41460_(ItemStack stack) {
        return this.jetpackType.getRarity();
    }

    public boolean isEngineOn(ItemStack stack) {
        return NBTUtil.getBoolean(stack, "Engine");
    }

    public void setEngineOn(ItemStack stack, Player player, boolean engineOn) {
        NBTUtil.flipBoolean(stack, "Engine");
        Component msg = TextUtils.getStateToggle("engineMode", engineOn);
        player.m_5661_(msg, true);
    }

    public boolean isHoverOn(ItemStack stack) {
        return NBTUtil.getBoolean(stack, "Hover");
    }

    public void setHoverOn(ItemStack stack, Player player, boolean hoverOn) {
        if (this.jetpackType.getHoverMode()) {
            NBTUtil.flipBoolean(stack, "Hover");
            Component msg = TextUtils.getStateToggle("hoverMode", hoverOn);
            player.m_5661_(msg, true);
        }
    }

    public boolean isEHoverOn(ItemStack stack) {
        return NBTUtil.getBoolean(stack, "EmergencyHover");
    }

    public void setEHoverOn(ItemStack stack, Player player, boolean eHoverOn) {
        if (this.jetpackType.getEmergencyHoverMode()) {
            NBTUtil.flipBoolean(stack, "EmergencyHover");
            Component msg = TextUtils.getStateToggle("emergencyHoverMode", eHoverOn);
            player.m_5661_(msg, true);
        }
    }

    private void doEHover(ItemStack stack, Player player) {
        if (this.jetpackType.getHoverMode()) {
            NBTUtil.setBoolean(stack, "Engine", true);
            NBTUtil.setBoolean(stack, "Hover", true);
            Component msg = TextUtils.getEmergencyText();
            player.m_5661_(msg, true);
        }
    }

    public boolean isChargerOn(ItemStack stack) {
        return NBTUtil.getBoolean(stack, "Charger");
    }

    public void setChargerOn(ItemStack stack, Player player, boolean chargerOn) {
        if (this.jetpackType.getChargerMode()) {
            NBTUtil.flipBoolean(stack, "Charger");
            Component msg = TextUtils.getStateToggle("chargerMode", chargerOn);
            player.m_5661_(msg, true);
        }
    }

    public static float getChargeRatio(ItemStack stack) {
        LazyOptional optional = stack.getCapability(ForgeCapabilities.ENERGY);
        if (optional.isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            return (float)energyStorage.getEnergyStored() / (float)energyStorage.getMaxEnergyStored();
        }
        return 0.0f;
    }

    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundTag nbt) {
        final JetpackItem container = this;
        return new ICapabilityProvider(){

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                if (cap == ForgeCapabilities.ENERGY) {
                    return LazyOptional.of(() -> new EnergyStorageImpl(stack, container)).cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level levelIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (ForgeCapabilities.ENERGY == null) {
            return;
        }
        TextUtils.addBaseInfo(stack, tooltip);
        if (KeyboardUtil.isHoldingShift()) {
            TextUtils.addShiftInfo(stack, tooltip);
        } else {
            tooltip.add(TextUtils.getShiftText());
        }
    }

    public boolean m_142522_(ItemStack stack) {
        return !this.isCreative && this.getEnergy(stack) > 0;
    }

    public int m_142158_(ItemStack stack) {
        return Math.round(13.0f * JetpackItem.getChargeRatio(stack));
    }

    public int m_142159_(ItemStack stack) {
        return 261193;
    }

    public ItemStack asChargedCopy() {
        ItemStack full = new ItemStack((ItemLike)this);
        NBTUtil.setInt(full, "Energy", this.jetpackType.getEnergyCapacity());
        return full;
    }

    public static int clamp(int min, int value, int max) {
        if (value < min) {
            return min;
        }
        return Math.min(value, max);
    }

    private void setEnergyStored(ItemStack container, int value) {
        NBTUtil.setInt(container, "Energy", JetpackItem.clamp(value, 0, this.getCapacity(container)));
    }

    public int getEnergyReceive() {
        return this.jetpackType.getEnergyPerTickIn();
    }

    public int getEnergyExtract() {
        return this.jetpackType.getEnergyUsage();
    }

    public static int getParticleId(ItemStack stack) {
        return stack.m_41784_().m_128441_("ParticleID") ? stack.m_41784_().m_128451_("ParticleID") : JetpackType.getDefaultParticles(stack);
    }

    public void setThrottle(ItemStack stack, int value) {
        NBTUtil.setInt(stack, "Throttle", value);
    }

    public int getThrottle(ItemStack stack) {
        return stack.m_41784_().m_128441_("Throttle") ? stack.m_41784_().m_128451_("Throttle") : 100;
    }

    public void useEnergy(ItemStack container, int amount) {
        if (container.m_41783_() != null || container.m_41783_().m_128441_("Energy")) {
            int stored = Math.min(container.m_41783_().m_128451_("Energy"), this.getCapacity(container));
            if ((stored -= amount) < 0) {
                stored = 0;
            }
            container.m_41783_().m_128405_("Energy", stored);
        }
    }

    public int getEnergyUsage(ItemStack stack) {
        int baseUsage = this.jetpackType.getEnergyUsage();
        int level = EnchantmentHelper.m_44843_((Enchantment)((Enchantment)RegistryHandler.FUEL_EFFICIENCY.get()), (ItemStack)stack);
        return level != 0 ? (int)Math.round((double)(baseUsage * (5 - level)) / 5.0) : baseUsage;
    }

    public void chargeInventory(Player player, ItemStack stack) {
        if (!player.m_20193_().f_46443_ && (this.getEnergy(stack) > 0 || this.isCreative)) {
            for (ItemStack itemStack : player.m_6167_()) {
                this.charge(stack, itemStack);
            }
            for (ItemStack itemStack : player.m_6168_()) {
                this.charge(stack, itemStack);
            }
        }
    }

    private void charge(ItemStack jetpack, ItemStack item) {
        LazyOptional optional;
        if (!item.equals(jetpack) && item.getCapability(ForgeCapabilities.ENERGY).isPresent() && (optional = item.getCapability(ForgeCapabilities.ENERGY)).isPresent()) {
            IEnergyStorage energyStorage = (IEnergyStorage)optional.orElseThrow(IllegalStateException::new);
            if (this.isCreative) {
                energyStorage.receiveEnergy(1000, false);
            } else {
                this.useEnergy(jetpack, energyStorage.receiveEnergy(this.getEnergyUsage(jetpack), false));
            }
        }
    }

    private void fly(Player player, double y) {
        Vec3 motion = player.m_20184_();
        player.m_20334_(motion.m_82507_(Direction.Axis.X), y, motion.m_82507_(Direction.Axis.Z));
    }

    public boolean m_8120_(ItemStack itemStack) {
        return itemStack.m_41720_() instanceof JetpackItem;
    }

    public void flyUser(Player player, ItemStack stack, JetpackItem item, Boolean force) {
        if (this.isEngineOn(stack)) {
            this.hoverMode = this.isHoverOn(stack);
            this.hoverSpeed = CommonJetpackHandler.isInverted(player) == CommonJetpackHandler.isHoldingDown(player) ? this.jetpackType.getSpeedVerticalHoverSlow() : this.jetpackType.getSpeedVerticalHover();
            this.flyKeyDown = force != false || CommonJetpackHandler.isHoldingUp(player);
            this.descendKeyDown = CommonJetpackHandler.isHoldingDown(player);
            this.currentAccel = this.jetpackType.getAccelVertical() * (player.m_20184_().m_82507_(Direction.Axis.Y) < 0.3 ? 2.5 : 1.0);
            this.currentSpeedVertical = this.jetpackType.getSpeedVertical() * (player.m_20069_() ? 0.4 : 1.0);
            this.speedVerticalHover = this.jetpackType.getSpeedVerticalHover();
            this.speedVerticalHoverSlow = this.jetpackType.getSpeedVerticalHoverSlow();
            if (this.flyKeyDown || this.hoverMode && !player.m_20096_()) {
                if (!this.isCreative) {
                    int amount = (int)(player.m_20142_() ? Math.round((double)this.getEnergyUsage(stack) * this.jetpackType.getSprintEnergyModifier()) : (long)this.getEnergyUsage(stack));
                    this.useEnergy(stack, amount);
                }
                if (this.getEnergy(stack) > 0 || this.isCreative) {
                    if (this.flyKeyDown) {
                        if (!this.hoverMode) {
                            this.fly(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + this.currentAccel, this.currentSpeedVertical));
                        } else if (this.descendKeyDown) {
                            this.fly(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + this.currentAccel, -this.speedVerticalHoverSlow));
                        } else {
                            this.fly(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + this.currentAccel, this.speedVerticalHover - (double)0.15f));
                        }
                    } else {
                        this.fly(player, Math.min(player.m_20184_().m_82507_(Direction.Axis.Y) + this.currentAccel, -this.hoverSpeed));
                    }
                    double baseSpeedSideways = this.jetpackType.getSpeedSideways();
                    double sprintSpeedModifier = this.jetpackType.getSprintSpeedModifier();
                    float speedSideways = (float)(player.m_6047_() ? baseSpeedSideways * 0.5 : baseSpeedSideways) * ((float)this.getThrottle(stack) / 100.0f);
                    float speedForward = (float)(player.m_20142_() ? (double)speedSideways * sprintSpeedModifier : (double)speedSideways) * ((float)this.getThrottle(stack) / 100.0f);
                    if (CommonJetpackHandler.isHoldingForwards(player)) {
                        player.m_19920_(1.0f, new Vec3(0.0, 0.0, (double)speedForward));
                    }
                    if (CommonJetpackHandler.isHoldingBackwards(player)) {
                        player.m_19920_(1.0f, new Vec3(0.0, 0.0, (double)(-speedSideways * 0.8f)));
                    }
                    if (CommonJetpackHandler.isHoldingLeft(player)) {
                        player.m_19920_(1.0f, new Vec3((double)speedSideways, 0.0, 0.0));
                    }
                    if (CommonJetpackHandler.isHoldingRight(player)) {
                        player.m_19920_(1.0f, new Vec3((double)(-speedSideways), 0.0, 0.0));
                    }
                    if (!player.m_20193_().m_5776_()) {
                        player.f_19789_ = 0.0f;
                        if (player instanceof ServerPlayer) {
                            I_ServerGamePacketListenerImpl mixinObj = (I_ServerGamePacketListenerImpl)((ServerPlayer)player).f_8906_;
                            mixinObj.setAboveGroundTickCount(0);
                        }
                    }
                }
            }
        }
        if (!(player.m_20193_().f_46443_ || !this.isEHoverOn(stack) || item.getEnergy(stack) <= 0 && !this.isCreative || this.isHoverOn(stack) && this.isEngineOn(stack))) {
            if (player.m_20182_().m_82507_(Direction.Axis.Y) < -69.0) {
                this.doEHover(stack, player);
            } else if (!player.m_7500_() && player.f_19789_ - 1.2f >= player.m_21223_()) {
                for (int j = 0; j <= 16; ++j) {
                    if (player.m_20096_() || player.m_6069_()) continue;
                    this.doEHover(stack, player);
                    break;
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addHUDInfo(ItemStack stack, List<Component> list) {
        TextUtils.addHUDInfoText(stack, list);
    }

    @Override
    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (this.getEnergyReceive() == 0) {
            return 0;
        }
        int energyStored = this.getEnergy(container);
        int energyReceived = Math.min(this.getCapacity(container) - energyStored, Math.min(this.getEnergyReceive(), maxReceive));
        if (!simulate) {
            this.setEnergyStored(container, energyStored + energyReceived);
        }
        return energyReceived;
    }

    @Override
    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (this.getEnergyExtract() == 0) {
            return 0;
        }
        int energyStored = this.getEnergy(container);
        int energyExtracted = Math.min(energyStored, Math.min(this.getEnergyExtract(), maxExtract));
        if (!simulate) {
            this.setEnergyStored(container, energyStored - energyExtracted);
        }
        return energyExtracted;
    }

    @Override
    public int getEnergy(ItemStack container) {
        return container.m_41784_().m_128451_("Energy");
    }

    @Override
    public int getCapacity(ItemStack container) {
        return this.jetpackType.getEnergyCapacity();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Rendering
    implements IClientItemExtensions {
        private static final Rendering INSTANCE = new Rendering();

        private Rendering() {
        }

        @NotNull
        public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
            return JetpackModelLayers.JETPACK_MODEL;
        }
    }
}

