/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.integration;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jetpacks.RegistryHandler;
import jetpacks.client.PilotGogglesRenderer;
import jetpacks.integration.JetpackRenderer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosIntegration {
    private static ResourceLocation getJetpackTexture(String name) {
        return new ResourceLocation("tjetpacks", "textures/models/armor/jetpack_" + name + ".png");
    }

    public static void initRenderers() {
        CuriosRendererRegistry.register((Item)((Item)RegistryHandler.PILOT_GOGGLES_IRON.get()), () -> new PilotGogglesRenderer(new ResourceLocation("tjetpacks", "textures/models/armor/pilot_goggles_iron.png")));
        CuriosRendererRegistry.register((Item)((Item)RegistryHandler.PILOT_GOGGLES_GOLD.get()), () -> new PilotGogglesRenderer(new ResourceLocation("tjetpacks", "textures/models/armor/pilot_goggles_gold.png")));
        CuriosRendererRegistry.register((Item)((Item)RegistryHandler.JETPACK_CREATIVE_ARMORED.get()), () -> new JetpackRenderer(CuriosIntegration.getJetpackTexture("creative_armored")));
        CuriosRendererRegistry.register((Item)((Item)RegistryHandler.JETPACK_TE1.get()), () -> new JetpackRenderer(CuriosIntegration.getJetpackTexture("te1")));
        CuriosRendererRegistry.register((Item)((Item)RegistryHandler.JETPACK_TE2.get()), () -> new JetpackRenderer(CuriosIntegration.getJetpackTexture("te2")));
        CuriosRendererRegistry.register((Item)((Item)RegistryHandler.JETPACK_TE3.get()), () -> new JetpackRenderer(CuriosIntegration.getJetpackTexture("te3")));
        CuriosRendererRegistry.register((Item)((Item)RegistryHandler.JETPACK_TE4.get()), () -> new JetpackRenderer(CuriosIntegration.getJetpackTexture("te4")));
        CuriosRendererRegistry.register((Item)((Item)RegistryHandler.JETPACK_TE5_ARMORED.get()), () -> new JetpackRenderer(CuriosIntegration.getJetpackTexture("te5_enderium")));
    }

    public static ICapabilityProvider initGogglesCapabilities(final ItemStack itemStack) {
        return CuriosIntegration.getProvider(new ICurio(){

            public void playRightClickEquipSound(LivingEntity livingEntity) {
                livingEntity.m_20193_().m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), ((ArmorItem)itemStack.m_41720_()).m_40401_().m_7344_(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }

            public ItemStack getStack() {
                return itemStack;
            }
        });
    }

    public static ICapabilityProvider initJetpackCapabilities(final ItemStack itemStack) {
        return CuriosIntegration.getProvider(new ICurio(){

            public void playRightClickEquipSound(LivingEntity livingEntity) {
                livingEntity.m_20193_().m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), ((ArmorItem)itemStack.m_41720_()).m_40401_().m_7344_(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }

            public ItemStack getStack() {
                return itemStack;
            }

            public boolean canRightClickEquip() {
                return true;
            }

            public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
                return true;
            }
        });
    }

    private static ICapabilityProvider getProvider(final ICurio curio) {
        return new ICapabilityProvider(){
            private final LazyOptional<ICurio> curioOptional = LazyOptional.of(() -> curio);

            @Nonnull
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
                return CuriosCapability.ITEM.orEmpty(cap, this.curioOptional);
            }
        };
    }
}

