/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.handlers;

import jetpacks.client.ui.JetpackScreen;
import jetpacks.handlers.ClientJetpackHandler;
import jetpacks.item.JetpackItem;
import jetpacks.network.NetworkHandler;
import jetpacks.network.packets.PacketSetCharger;
import jetpacks.network.packets.PacketSetEHover;
import jetpacks.network.packets.PacketSetEngine;
import jetpacks.network.packets.PacketSetHover;
import jetpacks.network.packets.PacketUpdateThrottle;
import jetpacks.network.packets.ToggleStatus;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tjetpacks", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class KeybindHandler {
    public static KeyMapping JETPACK_GUI_KEY = new KeyMapping("keybind.tjetpacks.jetpack_gui", 74, "keybind.tjetpacks.category");
    public static KeyMapping JETPACK_ENGINE_KEY = new KeyMapping("keybind.tjetpacks.jetpack_engine", -1, "keybind.tjetpacks.category");
    public static KeyMapping JETPACK_HOVER_KEY = new KeyMapping("keybind.tjetpacks.jetpack_hover", 72, "keybind.tjetpacks.category");
    public static KeyMapping JETPACK_EHOVER_KEY = new KeyMapping("keybind.tjetpacks.jetpack_ehover", -1, "keybind.tjetpacks.category");
    public static KeyMapping JETPACK_CHARGER_KEY = new KeyMapping("keybind.tjetpacks.jetpack_charger", -1, "keybind.tjetpacks.category");
    public static KeyMapping JETPACK_THROTTLE_INCREASE = new KeyMapping("keybind.tjetpacks.jetpack_throttle_increase", -1, "keybind.tjetpacks.category");
    public static KeyMapping JETPACK_THROTTLE_DECREASE = new KeyMapping("keybind.tjetpacks.jetpack_throttle_decrease", -1, "keybind.tjetpacks.category");

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        event.register(JETPACK_GUI_KEY);
        event.register(JETPACK_ENGINE_KEY);
        event.register(JETPACK_HOVER_KEY);
        event.register(JETPACK_EHOVER_KEY);
        event.register(JETPACK_CHARGER_KEY);
        event.register(JETPACK_THROTTLE_INCREASE);
        event.register(JETPACK_THROTTLE_DECREASE);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        Item item;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null || event.getAction() != 1 || Minecraft.m_91087_().f_91080_ != null) {
            return;
        }
        ItemStack jetpackStack = ClientJetpackHandler.global_checkForEquippedJetpack((Player)player);
        if (!jetpackStack.m_41619_() && (item = jetpackStack.m_41720_()) instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (JETPACK_GUI_KEY.getKey().m_84873_() == event.getKey()) {
                Minecraft.m_91087_().m_91152_((Screen)new JetpackScreen());
            }
            if (JETPACK_ENGINE_KEY.getKey().m_84873_() == event.getKey()) {
                NetworkHandler.sendToServer(new PacketSetEngine(ToggleStatus.TOGGLE));
            }
            if (JETPACK_HOVER_KEY.getKey().m_84873_() == event.getKey()) {
                NetworkHandler.sendToServer(new PacketSetHover(ToggleStatus.TOGGLE));
            }
            if (JETPACK_EHOVER_KEY.getKey().m_84873_() == event.getKey()) {
                NetworkHandler.sendToServer(new PacketSetEHover(ToggleStatus.TOGGLE));
            }
            if (JETPACK_CHARGER_KEY.getKey().m_84873_() == event.getKey()) {
                NetworkHandler.sendToServer(new PacketSetCharger(ToggleStatus.TOGGLE));
            }
            if (JETPACK_THROTTLE_INCREASE.getKey().m_84873_() == event.getKey()) {
                NetworkHandler.sendToServer(new PacketUpdateThrottle(Math.max(0, Math.min(100, jetpack.getThrottle(jetpackStack) + 10))));
            }
            if (JETPACK_THROTTLE_DECREASE.getKey().m_84873_() == event.getKey()) {
                NetworkHandler.sendToServer(new PacketUpdateThrottle(Math.max(0, Math.min(100, jetpack.getThrottle(jetpackStack) - 10))));
            }
        }
    }
}

