/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.handlers;

import java.util.Random;
import jetpacks.ThermalJetpacks;
import jetpacks.config.ModConfig;
import jetpacks.handlers.CommonJetpackHandler;
import jetpacks.handlers.JetpackSoundEvent;
import jetpacks.item.JetpackItem;
import jetpacks.item.JetpackType;
import jetpacks.network.NetworkHandler;
import jetpacks.network.packets.PacketUpdateInput;
import jetpacks.util.JetpackParticleType;
import jetpacks.util.JetpackUtil;
import jetpacks.util.Pos3D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientJetpackHandler {
    private static JetpackItem CLIENT_GLOBAL_JETPACK;
    private static ItemStack CLIENT_GLOBAL_JETPACK_STACK;
    private static JetpackItem jetpack;
    private static ItemStack jetpackStack;
    private static boolean lastFlyState;
    private static boolean lastInvertHover;
    private static boolean lastDescendState;
    private static boolean lastForwardState;
    private static boolean lastBackwardState;
    private static boolean lastLeftState;
    private static boolean lastRightState;
    private final Random rand = new Random();

    @SubscribeEvent
    public void onClientPlayerQuit(ClientPlayerNetworkEvent.LoggingOut loggedOutEvent) {
        ThermalJetpacks.LOGGER.info("Reverting jetpack settings to client config.");
        JetpackType.loadAllConfigs();
        ThermalJetpacks.LOGGER.info("Client jetpack config successfully reverted.");
    }

    public static ItemStack global_checkForEquippedJetpack(Player player) {
        JetpackItem jetpack2;
        Item item;
        CLIENT_GLOBAL_JETPACK_STACK = JetpackUtil.getItemFromChest(player);
        CLIENT_GLOBAL_JETPACK = !CLIENT_GLOBAL_JETPACK_STACK.m_41619_() && (item = CLIENT_GLOBAL_JETPACK_STACK.m_41720_()) instanceof JetpackItem ? (jetpack2 = (JetpackItem)item) : null;
        return CLIENT_GLOBAL_JETPACK_STACK;
    }

    public static JetpackItem global_getEquippedJetpack() {
        return CLIENT_GLOBAL_JETPACK;
    }

    public static ItemStack global_getEquippedJetpackStack() {
        return CLIENT_GLOBAL_JETPACK_STACK;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            jetpack = ClientJetpackHandler.global_getEquippedJetpack();
            jetpackStack = ClientJetpackHandler.global_getEquippedJetpackStack();
            if (jetpack == null) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91074_ != null && minecraft.f_91073_ != null && !minecraft.f_91074_.m_5833_() && !minecraft.f_91074_.m_150110_().f_35935_) {
                if (minecraft.f_91073_.m_46467_() % 40L == 0L) {
                    ClientJetpackHandler.global_checkForEquippedJetpack((Player)minecraft.f_91074_);
                    if (ClientJetpackHandler.global_getEquippedJetpack() == null) {
                        return;
                    }
                }
                ClientJetpackHandler.common_updateFlightState(minecraft);
                if (this.isJetpackFlying(minecraft.f_91074_, jetpackStack, jetpack)) {
                    if (ModConfig.client_enableJetpackParticles && minecraft.f_91066_.m_231929_().m_231551_() != ParticleStatus.MINIMAL) {
                        this.makeParticles(minecraft, JetpackParticleType.CLOUD);
                    }
                    if (minecraft.f_91073_.m_46467_() % 3L == 0L && ModConfig.client_enableJetpackSounds && !JetpackSoundEvent.playing(minecraft.f_91074_.m_19879_())) {
                        minecraft.m_91106_().m_120367_((SoundInstance)new JetpackSoundEvent((Player)minecraft.f_91074_));
                    }
                }
            }
        }
    }

    private static void common_updateFlightState(Minecraft mc) {
        if (mc.f_91074_ != null) {
            boolean flyState = mc.f_91074_.f_108618_.f_108572_;
            boolean invertHover = ModConfig.client_invertHoverSneakingBehavior;
            boolean descendState = mc.f_91074_.f_108618_.f_108573_;
            boolean forwardState = mc.f_91074_.f_108618_.f_108568_;
            boolean backwardState = mc.f_91074_.f_108618_.f_108569_;
            boolean leftState = mc.f_91074_.f_108618_.f_108570_;
            boolean rightState = mc.f_91074_.f_108618_.f_108571_;
            if (flyState != lastFlyState || invertHover != lastInvertHover || descendState != lastDescendState || forwardState != lastForwardState || backwardState != lastBackwardState || leftState != lastLeftState || rightState != lastRightState) {
                lastFlyState = flyState;
                lastInvertHover = invertHover;
                lastDescendState = descendState;
                lastForwardState = forwardState;
                lastBackwardState = backwardState;
                lastLeftState = leftState;
                lastRightState = rightState;
                NetworkHandler.sendToServer(new PacketUpdateInput(invertHover, flyState, descendState, forwardState, backwardState, leftState, rightState));
                CommonJetpackHandler.update((Player)mc.f_91074_, invertHover, flyState, descendState, forwardState, backwardState, leftState, rightState);
            }
        }
    }

    private boolean isJetpackFlying(LocalPlayer player, ItemStack stack, JetpackItem jetpack) {
        if (jetpack.isEngineOn(stack) && (jetpack.getEnergy(stack) > 0 || jetpack.isCreative)) {
            if (jetpack.isHoverOn(stack)) {
                return !player.m_20096_();
            }
            return CommonJetpackHandler.isHoldingUp((Player)player);
        }
        return false;
    }

    private void makeParticles(Minecraft minecraft, JetpackParticleType particleType) {
        double[] dArray;
        ParticleOptions particle = particleType.getParticleData();
        float random = (this.rand.nextFloat() - 0.5f) * 0.1f;
        if (minecraft.f_91074_.m_6047_()) {
            double[] dArray2 = new double[2];
            dArray2[0] = -0.3;
            dArray = dArray2;
            dArray2[1] = -0.1;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = 0.0;
            dArray = dArray3;
            dArray3[1] = 0.0;
        }
        double[] sneakBonus = dArray;
        Pos3D playerPos = new Pos3D((Entity)minecraft.f_91074_).translate(0.0, 1.5, 0.0);
        Pos3D vLeft = new Pos3D(-0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]).rotate(minecraft.f_91074_.f_20883_, 0.0f);
        Pos3D vRight = new Pos3D(0.18, -0.9 + sneakBonus[1], -0.3 + sneakBonus[0]).rotate(minecraft.f_91074_.f_20883_, 0.0f);
        Pos3D v = playerPos.translate((Vec3)vLeft).translate((Vec3)new Pos3D(minecraft.f_91074_.m_20184_()));
        minecraft.f_91061_.m_107370_(particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
        v = playerPos.translate((Vec3)vRight).translate((Vec3)new Pos3D(minecraft.f_91074_.m_20184_()));
        minecraft.f_91061_.m_107370_(particle, v.f_82479_, v.f_82480_, v.f_82481_, (double)random, -0.2, (double)random);
    }

    static {
        CLIENT_GLOBAL_JETPACK_STACK = ItemStack.f_41583_;
        lastFlyState = false;
        lastInvertHover = false;
        lastDescendState = false;
        lastForwardState = false;
        lastBackwardState = false;
        lastLeftState = false;
        lastRightState = false;
    }
}

