/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.config;

import jetpacks.ThermalJetpacks;
import jetpacks.config.ConfigDefaults;
import jetpacks.config.JetpackConfig;
import jetpacks.item.JetpackType;
import jetpacks.network.NetworkHandler;
import jetpacks.network.packets.PacketJetpackConfigSync;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="tjetpacks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModConfig {
    public static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    public static ForgeConfigSpec CLIENT_CONFIG;
    public static ForgeConfigSpec COMMON_CONFIG;
    public static ForgeConfigSpec SERVER_CONFIG;
    private static ForgeConfigSpec.BooleanValue invertHoverSneakingBehavior;
    private static ForgeConfigSpec.BooleanValue enableJetpackSounds;
    private static ForgeConfigSpec.BooleanValue enableJetpackParticles;
    private static ForgeConfigSpec.BooleanValue showThrottle;
    private static ForgeConfigSpec.BooleanValue showExactEnergy;
    private static ForgeConfigSpec.BooleanValue enableStateMessages;
    private static ForgeConfigSpec.BooleanValue enableJetpackHud;
    private static ForgeConfigSpec.BooleanValue showHoverState;
    private static ForgeConfigSpec.BooleanValue showEHoverState;
    private static ForgeConfigSpec.BooleanValue showChargerState;
    private static ForgeConfigSpec.BooleanValue hudTextShadow;
    private static ForgeConfigSpec.IntValue hudTextColor;
    private static ForgeConfigSpec.IntValue hudXOffset;
    private static ForgeConfigSpec.IntValue hudYOffset;
    private static ForgeConfigSpec.LongValue hudScale;
    private static ForgeConfigSpec.EnumValue<ConfigDefaults.HUDPosition> hudTextPosition;
    public static boolean client_invertHoverSneakingBehavior;
    public static boolean client_enableJetpackSounds;
    public static boolean client_enableJetpackParticles;
    public static boolean client_showThrottle;
    public static boolean client_showExactEnergy;
    public static boolean client_enableStateMessages;
    public static boolean client_enableJetpackHud;
    public static boolean client_showHoverState;
    public static boolean client_showEHoverState;
    public static boolean client_showChargerState;
    public static boolean client_hudTextShadow;
    public static int client_hudTextColor;
    public static int client_hudXOffset;
    public static int client_hudYOffset;
    public static long client_hudScale;
    public static ConfigDefaults.HUDPosition client_hudTextPosition;

    public static void register() {
        ModConfig.setupClientConfig();
        ModConfig.setupCommonConfig();
        ModConfig.setupServerConfig();
        CLIENT_CONFIG = CLIENT_BUILDER.build();
        COMMON_CONFIG = COMMON_BUILDER.build();
        SERVER_CONFIG = SERVER_BUILDER.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_CONFIG);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG);
    }

    private static void setupClientConfig() {
        CLIENT_BUILDER.comment("Thermal Jetpacks - Client Configurations").push("tjetpacks-jetpack-client");
        CLIENT_BUILDER.comment("Controls Configurations").push("controls");
        invertHoverSneakingBehavior = CLIENT_BUILDER.comment("This sets whether you must hold sneak to hover.").translation("config.tjetpacks.invertHoverSneakingBehavior").define("invertHoverSneakingBehavior", false);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Audio Configurations").push("audio");
        enableJetpackSounds = CLIENT_BUILDER.comment("This sets whether Jetpack sounds will play.").translation("config.tjetpacks.enableJetpackSounds").define("enableJetpackSounds", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("Visual Configurations").push("visual");
        enableJetpackParticles = CLIENT_BUILDER.comment("This sets whether Jetpack particles will be displayed.").translation("config.tjetpacks.enableJetpackParticles").define("enableJetpackParticles", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.comment("GUI Configurations").push("gui");
        showThrottle = CLIENT_BUILDER.comment("Show the Throttle value in the Jetpack HUD.").translation("config.tjetpacks.showThrottle").define("showThrottle", true);
        showExactEnergy = CLIENT_BUILDER.comment("Show the exact energy of the Jetpack in the HUD.").translation("config.tjetpacks.showExactEnergy").define("showExactEnergy", false);
        enableStateMessages = CLIENT_BUILDER.comment("This sets whether or not Jetpack state messages will show.").translation("config.tjetpacks.enableStateMessages").define("enableStateMessages", true);
        enableJetpackHud = CLIENT_BUILDER.comment("This sets whether or not the Jetpack HUD will be visible.").translation("config.tjetpacks.enableJetpackHud").define("enableJetpackHud", true);
        showHoverState = CLIENT_BUILDER.comment("Show the Hover State in the HUD.").translation("config.tjetpacks.showHoverState").define("showHoverState", true);
        showEHoverState = CLIENT_BUILDER.comment("Show the Emergency Hover State in the HUD.").translation("config.tjetpacks.showEHoverState").define("showEHoverState", true);
        showChargerState = CLIENT_BUILDER.comment("Show the Charger State in the HUD.").translation("config.tjetpacks.showChargerState").define("showChargerState", true);
        hudTextColor = CLIENT_BUILDER.comment("This sets the color of the Jetpack HUD.").translation("config.tjetpacks.hudTextColor").defineInRange("hudTextColor", 0xFFFFFF, Integer.MIN_VALUE, Integer.MAX_VALUE);
        hudTextPosition = CLIENT_BUILDER.comment("Set the position of the Jetpack HUD on the screen.").translation("config.tjetpacks.hudTextPosition").defineEnum("hudTextPosition", (Enum)ConfigDefaults.hudTextPosition);
        hudXOffset = CLIENT_BUILDER.comment("Set the X offset of the Jetpack HUD on the screen.").translation("config.tjetpacks.hudXOffset").defineInRange("hudXOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        hudYOffset = CLIENT_BUILDER.comment("Set the Y offset of the Jetpack HUD on the screen.").translation("config.tjetpacks.hudYOffset").defineInRange("hudYOffset", 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        hudScale = CLIENT_BUILDER.comment("Set the scale of the Jetpack HUD on the screen.").translation("config.tjetpacks.hudScale").defineInRange("hudScale", 1L, 1L, 100L);
        hudTextShadow = CLIENT_BUILDER.comment("Set if the Jetpack HUD values have text shadows.").translation("config.tjetpacks.hudTextShadow").define("hudTextShadow", true);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.pop();
    }

    private static void setupCommonConfig() {
        COMMON_BUILDER.comment("Thermal Jetpacks - Common Configurations").push("tjetpacks-jetpack-common");
        COMMON_BUILDER.comment("Jetpack Tuning Configurations").push("tuning");
        JetpackConfig.createJetpackConfig(COMMON_BUILDER);
    }

    private static void setupServerConfig() {
        SERVER_BUILDER.comment("Thermal Jetpacks - Server Configurations").push("tjetpacks-jetpack-server");
        SERVER_BUILDER.pop();
    }

    public static void sendServerConfigFiles(Player player) {
        JetpackType.loadAllConfigs();
        for (JetpackType jetpack : JetpackType.JETPACK_ALL) {
            NetworkHandler.sendToClient(new PacketJetpackConfigSync(jetpack), (ServerPlayer)player);
        }
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        ThermalJetpacks.LOGGER.info("Config Loaded: {}", (Object)configEvent.getConfig().getFileName());
        if (configEvent.getConfig().getFileName().equals("tjetpacks-common.toml")) {
            JetpackType.loadAllConfigs();
        } else if (configEvent.getConfig().getFileName().equals("tjetpacks-client.toml")) {
            client_invertHoverSneakingBehavior = (Boolean)invertHoverSneakingBehavior.get();
            client_enableJetpackSounds = (Boolean)enableJetpackSounds.get();
            client_enableJetpackParticles = (Boolean)enableJetpackParticles.get();
            client_showThrottle = (Boolean)showThrottle.get();
            client_showExactEnergy = (Boolean)showExactEnergy.get();
            client_enableStateMessages = (Boolean)enableStateMessages.get();
            client_enableJetpackHud = (Boolean)enableJetpackHud.get();
            client_showHoverState = (Boolean)showHoverState.get();
            client_showEHoverState = (Boolean)showEHoverState.get();
            client_showChargerState = (Boolean)showChargerState.get();
            client_hudTextShadow = (Boolean)hudTextShadow.get();
            client_hudTextColor = (Integer)hudTextColor.get();
            client_hudXOffset = (Integer)hudXOffset.get();
            client_hudYOffset = (Integer)hudYOffset.get();
            client_hudScale = (Long)hudScale.get();
            client_hudTextPosition = (ConfigDefaults.HUDPosition)((Object)hudTextPosition.get());
        }
    }
}

