/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.client.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import jetpacks.client.ui.ToggleImageButton;
import jetpacks.handlers.KeybindHandler;
import jetpacks.item.JetpackItem;
import jetpacks.network.NetworkHandler;
import jetpacks.network.packets.PacketSetCharger;
import jetpacks.network.packets.PacketSetEHover;
import jetpacks.network.packets.PacketSetEngine;
import jetpacks.network.packets.PacketSetHover;
import jetpacks.network.packets.PacketUpdateClientJetpackUI;
import jetpacks.network.packets.PacketUpdateThrottle;
import jetpacks.network.packets.ToggleStatus;
import jetpacks.util.JetpackUtil;
import jetpacks.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.gui.widget.ForgeSlider;

@OnlyIn(value=Dist.CLIENT)
public class JetpackScreen
extends Screen {
    private static final Minecraft minecraft = Minecraft.m_91087_();
    private static final float LEAN_FACTOR = 2.0f;
    private final ResourceLocation JETPACK_TEXTURE = new ResourceLocation("tjetpacks", "textures/gui/jetpack_screen.png");
    private static final int WIDTH = 150;
    private static final int HEIGHT = 144;
    private static final int Y_UI_BELOW_TEXT = 20;
    private final JetpackItem jetpackItem;
    private final ItemStack jetpackStack;
    private static ToggleImageButton engineButton;
    private static ToggleImageButton hoverButton;
    private static ToggleImageButton ehoverButton;
    private static ToggleImageButton chargerButton;
    private ForgeSlider slider;
    final int barOffTextureStartX = 0;
    final int barOnTextureStartX = 14;
    final int barCreativeTextureStartX = 56;
    final int barTexStartY = 170;
    final int barXStart = 10;
    final int barYStart = 20;
    final int barHeight = 86;
    final int barWidth = 14;

    public JetpackScreen() {
        super((Component)Component.m_237115_((String)"screen.tjetpacks.jetpack_screen.title"));
        this.f_96543_ = 150;
        this.f_96544_ = 144;
        this.jetpackItem = (JetpackItem)JetpackUtil.getItemFromChest((Player)JetpackScreen.minecraft.f_91074_).m_41720_();
        this.jetpackStack = JetpackUtil.getItemFromChest((Player)JetpackScreen.minecraft.f_91074_);
    }

    public static void update(boolean engineOn, boolean hoverOn, boolean eHoverOn, boolean chargerOn) {
        if (engineButton != null) {
            engineButton.setToggled(engineOn);
        }
        if (hoverButton != null) {
            hoverButton.setToggled(hoverOn);
        }
        if (ehoverButton != null) {
            ehoverButton.setToggled(eHoverOn);
        }
        if (chargerButton != null) {
            chargerButton.setToggled(chargerOn);
        }
    }

    protected void m_7856_() {
        int relX = (this.f_96543_ - 150) / 2;
        int relY = (this.f_96544_ - 144) / 2;
        Item item = this.jetpackStack.m_41720_();
        LocalPlayer player = JetpackScreen.minecraft.f_91074_;
        assert (player != null);
        NetworkHandler.sendToServer(new PacketUpdateClientJetpackUI());
        if (item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            int y = 20;
            int x = 120;
            engineButton = new ToggleImageButton(relX + x, relY + y, 20, 20, 176, 40, 20, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketSetEngine(ToggleStatus.TOGGLE)));
            engineButton.setToggled(false);
            engineButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.tjetpacks.engine_on")));
            if (JetpackScreen.engineButton.f_93623_) {
                y += 22;
                this.m_142416_((GuiEventListener)engineButton);
            }
            hoverButton = new ToggleImageButton(relX + x, relY + y, 20, 20, 216, 40, 20, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketSetHover(ToggleStatus.TOGGLE)));
            hoverButton.setToggled(false);
            hoverButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.tjetpacks.hover_on")));
            JetpackScreen.hoverButton.f_93623_ = jetpack.getJetpackType().getHoverMode();
            if (JetpackScreen.hoverButton.f_93623_) {
                y += 22;
                this.m_142416_((GuiEventListener)hoverButton);
            }
            chargerButton = new ToggleImageButton(relX + x, relY + y, 20, 20, 196, 40, 20, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketSetCharger(ToggleStatus.TOGGLE)));
            chargerButton.setToggled(false);
            chargerButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.tjetpacks.charger_on")));
            JetpackScreen.chargerButton.f_93623_ = jetpack.getJetpackType().getChargerMode();
            if (JetpackScreen.chargerButton.f_93623_) {
                y += 22;
                this.m_142416_((GuiEventListener)chargerButton);
            }
            ehoverButton = new ToggleImageButton(relX + x, relY + y, 20, 20, 236, 40, 20, 0, this.JETPACK_TEXTURE, button -> NetworkHandler.sendToServer(new PacketSetEHover(ToggleStatus.TOGGLE)));
            ehoverButton.setToggled(false);
            ehoverButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"tooltip.tjetpacks.ehover_on")));
            JetpackScreen.ehoverButton.f_93623_ = jetpack.getJetpackType().getEmergencyHoverMode();
            if (JetpackScreen.ehoverButton.f_93623_) {
                y += 22;
                this.m_142416_((GuiEventListener)ehoverButton);
            }
        }
        this.slider = new ForgeSlider(relX + 10, relY + 118, 130, 16, (Component)Component.m_237115_((String)"screen.tjetpacks.throttle"), (Component)Component.m_237113_((String)"%"), 0.0, 100.0, (double)this.jetpackItem.getThrottle(this.jetpackStack), true);
        this.m_142416_((GuiEventListener)this.slider);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Component text;
        int relX = (this.f_96543_ - 150) / 2;
        int relY = (this.f_96544_ - 144) / 2;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.JETPACK_TEXTURE);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.m_280218_(this.JETPACK_TEXTURE, relX, relY, 0, 0, 150, 144);
        assert (JetpackScreen.minecraft.f_91080_ != null);
        float halfScreenHeight = (float)JetpackScreen.minecraft.f_91080_.f_96544_ / 2.0f;
        float halfScreenWidth = (float)JetpackScreen.minecraft.f_91080_.f_96543_ / 2.0f;
        float angleX = -(((float)mouseX - halfScreenWidth) / halfScreenWidth * 2.0f);
        float angleY = -(((float)(mouseY + 25) - halfScreenHeight) / halfScreenHeight * 2.0f);
        InventoryScreen.renderEntityInInventoryFollowsAngle((GuiGraphics)graphics, (int)(relX + 75 - 4), (int)(relY + 100), (int)38, (float)angleX, (float)angleY, (LivingEntity)JetpackScreen.minecraft.f_91074_);
        int textWidth = JetpackScreen.minecraft.f_91062_.m_92852_((FormattedText)Component.m_237115_((String)this.jetpackStack.m_41778_()));
        graphics.m_280614_(JetpackScreen.minecraft.f_91062_, (Component)Component.m_237115_((String)this.jetpackStack.m_41778_()), relX + (150 - textWidth) / 2, relY + 5, 0x303030, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.JETPACK_TEXTURE);
        NetworkHandler.sendToServer(new PacketUpdateThrottle(this.slider.getValueInt()));
        int amount = this.getEnergyBarAmount(86);
        int barOffset = 86 - amount;
        graphics.m_280218_(this.JETPACK_TEXTURE, relX + 10, relY + 20, this.jetpackItem.isCreative ? 56 : 0, 170, 14, 86);
        if (!this.jetpackItem.isCreative) {
            graphics.m_280218_(this.JETPACK_TEXTURE, relX + 10, relY + 20 + 1 + barOffset, 14, 171, 14, amount - 2);
        }
        if (mouseX >= relX + 10 && mouseY >= relY + 20 && mouseX < relX + 10 + 14 && mouseY < relY + 20 + 86 && (text = this.jetpackItem.isCreative ? TextUtils.translate("tooltip", "infiniteEnergy", ChatFormatting.LIGHT_PURPLE, new Object[0]) : (this.jetpackItem.getEnergy(this.jetpackStack) == 0 ? TextUtils.translate("hud", "energyDepleted", ChatFormatting.RED, new Object[0]) : TextUtils.energyWithMax(this.jetpackItem.getEnergy(this.jetpackStack), this.jetpackItem.getCapacity(this.jetpackStack)))) != null) {
            graphics.m_280557_(this.f_96547_, text, mouseX, mouseY);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private int getEnergyBarAmount(int barHeight) {
        Item item = this.jetpackStack.m_41720_();
        if (item instanceof JetpackItem) {
            JetpackItem jetpack = (JetpackItem)item;
            if (jetpack.isCreative) {
                return barHeight;
            }
            int i = jetpack.getEnergy(this.jetpackStack);
            int j = jetpack.getCapacity(this.jetpackStack);
            return (int)(j != 0 && i != 0 ? (long)i * (long)barHeight / (long)j : 0L);
        }
        return 0;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (KeybindHandler.JETPACK_GUI_KEY.m_90832_(keyCode, scanCode) || JetpackScreen.minecraft.f_91066_.f_92092_.m_90832_(keyCode, scanCode)) {
            minecraft.m_91152_(null);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }
}

