/*
 * Decompiled with CFR 0.152.
 */
package jetpacks.client.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import jetpacks.client.ui.HUDRenderHelper;
import jetpacks.config.ModConfig;
import jetpacks.handlers.ClientJetpackHandler;
import jetpacks.item.JetpackItem;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public final class HUDHandler {
    public static boolean renderJetpackHUD = false;
    private static final IGuiOverlay HUD_OVERLAY = (gui, gfx, partialTick, width, height) -> {
        if (renderJetpackHUD) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (ModConfig.client_enableJetpackHud && !minecraft.f_91066_.f_92062_ && !minecraft.f_91066_.f_92063_ && minecraft.f_91074_ != null && minecraft.f_91073_ != null) {
                Item patt1686$temp;
                ItemStack jetpackItem;
                if (minecraft.f_91073_.m_46467_() % 40L == 0L) {
                    ClientJetpackHandler.global_checkForEquippedJetpack((Player)minecraft.f_91074_);
                }
                if (!(jetpackItem = ClientJetpackHandler.global_getEquippedJetpackStack()).m_41619_() && (patt1686$temp = jetpackItem.m_41720_()) instanceof JetpackItem) {
                    JetpackItem provider = (JetpackItem)patt1686$temp;
                    ArrayList<Component> renderStrings = new ArrayList<Component>();
                    provider.addHUDInfo(jetpackItem, renderStrings);
                    if (renderStrings.isEmpty()) {
                        return;
                    }
                    int count = 0;
                    PoseStack matrix = gfx.m_280168_();
                    matrix.m_85836_();
                    matrix.m_85841_((float)ModConfig.client_hudScale, (float)ModConfig.client_hudScale, 1.0f);
                    Window window = minecraft.m_91268_();
                    for (Component text : renderStrings) {
                        HUDRenderHelper.drawStringAtPosition(gfx, window, text, count);
                        ++count;
                    }
                    matrix.m_85849_();
                }
            }
        }
    };

    @SubscribeEvent
    public void registerOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "hud", HUD_OVERLAY);
    }
}

